/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.api.TypeField;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.FactType;

public final class BetaFieldReference {
    private final FactType factType;
    private final ActiveField activeField;

    public BetaFieldReference(FactType factType, TypeField field) {
        this.factType = factType;
        this.activeField = factType.getMemoryAddress().fields().getFields()[factType.findFieldPosition(field)];
    }

    public FactType getFactType() {
        return this.factType;
    }

    public ActiveField getActiveField() {
        return this.activeField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetaFieldReference that = (BetaFieldReference)o;
        return this.activeField.equals(that.activeField) && this.factType.equals(that.factType);
    }

    public int hashCode() {
        return this.factType.hashCode() * 31 + this.activeField.hashCode();
    }
}

