/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import org.evrete.api.Action;
import org.evrete.runtime.MemoryActionListener;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.Mask;

public class DeltaMemoryManager
implements MemoryActionListener {
    private final int[] actionCounts = new int[Action.values().length];
    private int totalActions = 0;
    private final Mask<MemoryAddress> insertDeltaMask = Mask.addressMask();
    private final Mask<MemoryAddress> deleteBufferMask = Mask.addressMask();

    boolean hasMemoryChanges() {
        return this.totalActions > 0;
    }

    int deltaOperations() {
        return this.actionCounts[Action.INSERT.ordinal()] + this.actionCounts[Action.UPDATE.ordinal()];
    }

    @Override
    public void onBufferAction(int type, Action action, int delta) {
        this.totalActions += delta;
        int n = action.ordinal();
        this.actionCounts[n] = this.actionCounts[n] + delta;
    }

    void onDelete(Mask<MemoryAddress> mask) {
        this.deleteBufferMask.or(mask);
    }

    void onInsert(Mask<MemoryAddress> mask) {
        this.insertDeltaMask.or(mask);
    }

    void clearBufferData() {
        Arrays.fill(this.actionCounts, 0);
        this.totalActions = 0;
    }

    Mask<MemoryAddress> getInsertDeltaMask() {
        return this.insertDeltaMask;
    }

    void clearDeltaData() {
        this.insertDeltaMask.clear();
    }

    Mask<MemoryAddress> getDeleteDeltaMask() {
        return this.deleteBufferMask;
    }

    void clearDeleteData() {
        this.deleteBufferMask.clear();
    }

    public String toString() {
        return "{actions=" + Arrays.toString(this.actionCounts) + ", total=" + this.totalActions + '}';
    }
}

