/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.Mask;

public class FactRecord {
    final Object instance;
    private int version = 0;
    private final Mask<MemoryAddress> bucketsMask;

    FactRecord(Object instance) {
        this.instance = instance;
        this.bucketsMask = Mask.addressMask();
    }

    void markLocation(MemoryAddress address) {
        this.bucketsMask.set(address);
    }

    public Mask<MemoryAddress> getBucketsMask() {
        return this.bucketsMask;
    }

    public int getVersion() {
        return this.version;
    }

    public void updateVersion(int newVersion) {
        this.version = newVersion;
    }

    public String toString() {
        return "{obj=" + this.instance + ", ver=" + this.version + '}';
    }
}

