/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Objects;
import org.evrete.api.FactHandle;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.RuntimeFactType;

class RhsFactType {
    private final RuntimeFactType type;
    FactHandle handle;
    Object value;
    ReIterator<FactHandleVersioned> factIterator;
    private MemoryKey currentKey;
    private FactHandleVersioned currentFactHandle;

    RhsFactType(RuntimeFactType type) {
        this.type = type;
    }

    void resetState() {
        this.currentFactHandle = null;
        this.currentKey = null;
    }

    void setCurrentKey(MemoryKey key) {
        if (this.valueChanged(key)) {
            this.currentKey = key;
            this.currentFactHandle = null;
            KeyMode mode = KeyMode.values()[key.getMetaValue()];
            this.factIterator = this.type.factIterator(mode, key);
        }
    }

    private boolean valueChanged(MemoryKey key) {
        if (this.currentKey == null) {
            return true;
        }
        if (this.currentKey == key) {
            return false;
        }
        if (this.currentKey.getMetaValue() != key.getMetaValue()) {
            return true;
        }
        return !Objects.equals(key, this.currentKey);
    }

    boolean setCurrentFact(FactHandleVersioned v) {
        if (Objects.equals(v, this.currentFactHandle)) {
            return true;
        }
        FactHandle handle = v.getHandle();
        FactRecord fact = this.type.get(handle);
        if (fact == null || fact.getVersion() != v.getVersion()) {
            return false;
        }
        this.currentFactHandle = v;
        this.handle = handle;
        this.value = fact.instance;
        return true;
    }

    public String toString() {
        return "{type=" + this.type + ", key=" + this.currentKey + '}';
    }
}

