/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.evrete.api.Action;
import org.evrete.api.FactHandle;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.FactStorage;
import org.evrete.api.IntToValue;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.api.TypeResolver;
import org.evrete.api.ValueHandle;
import org.evrete.api.ValueResolver;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.AtomicMemoryAction;
import org.evrete.runtime.Evaluators;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.KeyMemoryBucket;
import org.evrete.runtime.MemoryActionBuffer;
import org.evrete.runtime.RuntimeFact;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.TypeMemoryBase;
import org.evrete.runtime.TypeMemoryMetaData;
import org.evrete.runtime.evaluation.AlphaEvaluator;
import org.evrete.runtime.evaluation.EvaluatorWrapper;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.Mask;

public final class TypeMemory
extends TypeMemoryBase {
    private static final Logger LOGGER = Logger.getLogger(TypeMemory.class.getName());
    private Cache cache;
    private final MemoryActionBuffer buffer;

    TypeMemory(SessionMemory sessionMemory, int type) {
        super(sessionMemory, type);
        int bufferSize = this.configuration.getAsInteger("evrete.core.insert-buffer-size", 4096);
        this.buffer = new MemoryActionBuffer(type, bufferSize, sessionMemory.runtime.deltaMemoryManager);
        this.updateCachedData();
    }

    void updateCachedData() {
        TypeResolver resolver = this.runtime.getTypeResolver();
        Type t = resolver.getType(this.type.getId());
        TypeMemoryMetaData meta = this.runtime.getTypeMeta(t.getId());
        this.cache = new Cache(t, meta.activeFields, this.runtime.getEvaluators(), meta.alphaEvaluators);
    }

    private FactRecord getFactRecord(FactHandle handle) {
        FactRecord record = null;
        AtomicMemoryAction bufferedAction = this.buffer.get(handle);
        if (bufferedAction != null) {
            if (bufferedAction.action != Action.RETRACT) {
                record = bufferedAction.factRecord;
            }
        } else {
            record = this.getStoredRecord(handle);
        }
        return record;
    }

    public Object getFact(FactHandle handle) {
        FactRecord record = this.getFactRecord(handle);
        return record == null ? null : record.instance;
    }

    public MemoryActionBuffer getBuffer() {
        return this.buffer;
    }

    void forEachFact(BiConsumer<FactHandle, Object> consumer) {
        this.factStorage.iterator().forEachRemaining(record -> {
            FactHandle handle = record.getHandle();
            Object fact = ((FactRecord)record.getInstance()).instance;
            AtomicMemoryAction bufferedAction = this.buffer.get(handle);
            if (bufferedAction == null) {
                consumer.accept(handle, fact);
            } else if (bufferedAction.action != Action.RETRACT) {
                consumer.accept(bufferedAction.handle, bufferedAction.factRecord.instance);
            }
        });
    }

    FactHandle externalInsert(Object fact) {
        FactRecord record = new FactRecord(fact);
        FactHandle handle = this.factStorage.insert(record);
        if (handle == null) {
            LOGGER.warning("Fact " + fact + " has been already inserted");
            return null;
        }
        return this.add(Action.INSERT, handle, record);
    }

    public FactHandle add(Action action, FactHandle factHandle, FactRecord factRecord) {
        this.buffer.add(action, factHandle, factRecord);
        return factHandle;
    }

    public RuntimeFact createFactRuntime(FactHandleVersioned factHandle, FactRecord factRecord) {
        return this.cache.createFactRuntime(factHandle, factRecord, this.valueResolver);
    }

    void onNewAlphaBucket(MemoryAddress address) {
        KeyMemoryBucket bucket = this.touchMemory(address);
        Iterator allFacts = this.factStorage.iterator();
        LinkedList<RuntimeFact> runtimeFacts = new LinkedList<RuntimeFact>();
        while (allFacts.hasNext()) {
            FactStorage.Entry rec = (FactStorage.Entry)allFacts.next();
            FactHandleVersioned fhv = new FactHandleVersioned(rec.getHandle(), ((FactRecord)rec.getInstance()).getVersion());
            runtimeFacts.add(this.createFactRuntime(fhv, (FactRecord)rec.getInstance()));
        }
        bucket.insert(runtimeFacts);
        bucket.commitBuffer();
    }

    static class AlphaPredicate {
        private final EvaluatorWrapper delegate;
        private final int index;
        private final IntToValue func;

        AlphaPredicate(AlphaEvaluator alphaEvaluator, Evaluators evaluators, Object[] values) {
            this.delegate = evaluators.get(alphaEvaluator.getDelegate());
            ActiveField[] activeDescriptor = alphaEvaluator.getDescriptor();
            this.index = alphaEvaluator.getIndex();
            int[] valueIndices = new int[activeDescriptor.length];
            for (int i2 = 0; i2 < valueIndices.length; ++i2) {
                valueIndices[i2] = activeDescriptor[i2].getValueIndex();
            }
            this.func = i -> values[valueIndices[i]];
        }

        int getIndex() {
            return this.index;
        }

        boolean test() {
            return this.delegate.test(this.func);
        }
    }

    static class Cache {
        final TypeField[] fields;
        final AlphaPredicate[] alphaEvaluators;
        final Object[] currentValues;
        final boolean hasAlphaConditions;

        Cache(Type<?> type, ActiveField[] activeFields, Evaluators evaluators, AlphaEvaluator[] alphaEvaluators) {
            int i;
            this.fields = new TypeField[activeFields.length];
            for (i = 0; i < activeFields.length; ++i) {
                this.fields[i] = type.getField(activeFields[i].field());
            }
            this.currentValues = new Object[this.fields.length];
            this.hasAlphaConditions = alphaEvaluators.length > 0;
            this.alphaEvaluators = new AlphaPredicate[alphaEvaluators.length];
            if (this.hasAlphaConditions) {
                for (i = 0; i < alphaEvaluators.length; ++i) {
                    this.alphaEvaluators[i] = new AlphaPredicate(alphaEvaluators[i], evaluators, this.currentValues);
                }
            }
        }

        private RuntimeFact createFactRuntime(FactHandleVersioned factHandle, FactRecord factRecord, ValueResolver valueResolver) {
            BitSet alphaTests;
            ValueHandle[] valueHandles = new ValueHandle[this.fields.length];
            if (this.hasAlphaConditions) {
                for (int i = 0; i < valueHandles.length; ++i) {
                    TypeField f = this.fields[i];
                    Object fieldValue = f.readValue(factRecord.instance);
                    this.currentValues[i] = fieldValue;
                    valueHandles[i] = valueResolver.getValueHandle(f.getValueType(), fieldValue);
                }
                alphaTests = new BitSet();
                for (AlphaPredicate alphaEvaluator : this.alphaEvaluators) {
                    if (!alphaEvaluator.test()) continue;
                    alphaTests.set(alphaEvaluator.getIndex());
                }
            } else {
                for (int i = 0; i < valueHandles.length; ++i) {
                    TypeField f = this.fields[i];
                    valueHandles[i] = valueResolver.getValueHandle(f.getValueType(), f.readValue(factRecord.instance));
                }
                alphaTests = Mask.EMPTY;
            }
            return new RuntimeFact(factRecord, factHandle, valueHandles, alphaTests);
        }
    }
}

