/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util.compiler;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.evrete.util.StringLiteralRemover;
import org.evrete.util.compiler.CompilationException;

final class JavaSource
extends SimpleJavaFileObject {
    private final String code;
    private static final String KEYWORD_CLASS = "class";
    private static final String KEYWORD_INTERFACE = "interface";
    private static final String KEYWORD_RECORD = "record";
    private static final String KEYWORD_ANNOTATION = "@interface";
    private static final String[] JAVA_TYPES = new String[]{"class", "interface", "record", "@interface"};
    private static final AtomicInteger folderId = new AtomicInteger();

    private JavaSource(URI uri, String code) {
        super(uri, JavaFileObject.Kind.SOURCE);
        this.code = code;
    }

    static Collection<JavaSource> task(String sourceCode) throws CompilationException {
        String derivedClassName = JavaSource.guessJavaClassName(sourceCode);
        String virtualFolder = "folder" + folderId.incrementAndGet();
        URI uri = URI.create("string:///" + virtualFolder + "/" + derivedClassName + JavaFileObject.Kind.SOURCE.extension);
        return Collections.singletonList(new JavaSource(uri, sourceCode));
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return this.code;
    }

    private static String guessJavaClassName(String source) throws CompilationException {
        int commentStart;
        Objects.requireNonNull(source, "Source can not be null");
        String stripped = source.replaceAll("\n\r", "\n");
        stripped = stripped.replaceAll("\r\n", "\n");
        stripped = stripped.replaceAll("\r", "\n");
        String[] lines = stripped.split("\n");
        StringBuilder sb = new StringBuilder(source.length());
        for (String line : lines) {
            if (line == null || line.isEmpty() || (line = line.trim()).startsWith("//") || line.startsWith("import") || line.startsWith("package")) continue;
            sb.append(line).append("\n");
        }
        stripped = sb.toString();
        StringLiteralRemover r = StringLiteralRemover.of(stripped, false);
        stripped = r.getConverted();
        for (String c : r.getConstantMap().keySet()) {
            int pos = stripped.indexOf(c);
            stripped = stripped.substring(0, pos) + "\"\"" + stripped.substring(pos + c.length());
        }
        while ((commentStart = stripped.indexOf("/*")) >= 0) {
            int commentEnd = stripped.indexOf("*/", commentStart);
            if (commentEnd < 0) {
                throw new CompilationException("Unable to derive type name: unbalanced block comments.", source);
            }
            stripped = stripped.substring(0, commentStart) + stripped.substring(commentEnd + 2);
        }
        stripped = JavaSource.clearBrackets(stripped, '(', ')');
        stripped = JavaSource.clearBrackets(stripped, '{', '}');
        while (stripped.contains("\n")) {
            stripped = stripped.replaceAll("\n", " ");
        }
        String[] typeDeclarationWords = stripped.replaceAll("\\s+", " ").split("\\s");
        for (String type : JAVA_TYPES) {
            int pos = JavaSource.findIndexOf(type, typeDeclarationWords);
            if (pos < 0) continue;
            int nameIndex = pos + 1;
            if (nameIndex >= typeDeclarationWords.length) {
                throw new IllegalStateException();
            }
            return typeDeclarationWords[nameIndex];
        }
        Logger.getAnonymousLogger().warning("Source code:\n" + source);
        throw new CompilationException("Unable to locate class definition, see the error logs for the corresponding source code", source);
    }

    private static String clearBrackets(String source, char openingBracket, char closingBracket) {
        int start;
        String current = source;
        block0: while ((start = current.indexOf(openingBracket)) >= 0) {
            int nested = 0;
            for (int pos = start + 1; pos < current.length(); ++pos) {
                char c = current.charAt(pos);
                if (c == openingBracket) {
                    ++nested;
                }
                if (c != closingBracket) continue;
                if (nested == 0) {
                    current = current.substring(0, start) + current.substring(pos + 1);
                    continue block0;
                }
                --nested;
            }
        }
        return current;
    }

    private static int findIndexOf(String arg, String[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arg.equals(arr[i])) continue;
            return i;
        }
        return -1;
    }
}

