/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.api.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.api.TypeResolver;

public interface DSLKnowledgeProvider {
    public String getName();

    default public Knowledge create(KnowledgeService service, URL ... resources) throws IOException {
        return this.create(service, service.newTypeResolver(), resources);
    }

    default public Knowledge create(KnowledgeService service, TypeResolver typeResolver, URL ... resources) throws IOException {
        if (resources == null || resources.length == 0) {
            throw new IOException("Empty resources");
        }
        InputStream[] streams = new InputStream[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            streams[i] = resources[i].openStream();
        }
        Knowledge knowledge = this.create(service, typeResolver, streams);
        for (InputStream stream : streams) {
            stream.close();
        }
        return knowledge;
    }

    default public Knowledge create(KnowledgeService service, InputStream ... streams) throws IOException {
        return this.create(service, service.newTypeResolver(), streams);
    }

    public Knowledge create(KnowledgeService var1, TypeResolver var2, InputStream ... var3) throws IOException;

    default public Knowledge create(KnowledgeService service, Reader ... streams) throws IOException {
        return this.create(service, service.newTypeResolver(), streams);
    }

    default public Knowledge create(KnowledgeService service, TypeResolver typeResolver, Reader ... streams) throws IOException {
        throw new UnsupportedOperationException("Method not supported by " + this.getClass().getName());
    }
}

