/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringJoiner;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;
import org.evrete.util.CollectionUtils;

public abstract class AbstractLinearHash<E>
implements ReIterable<E> {
    static final ToIntFunction<Object> DEFAULT_HASH = Object::hashCode;
    static final BiPredicate<Object, Object> DEFAULT_EQUALS = Object::equals;
    private static final float loadFactor = 0.75f;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int MINIMUM_CAPACITY = 2;
    private static final int NULL_VALUE = -1;
    private final int minDataSize;
    int size = 0;
    private Object[] data;
    private boolean[] deletedIndices;
    private int deletes = 0;
    private int currentInsertIndex;
    private int[] unsignedIndices;

    protected AbstractLinearHash(int minCapacity) {
        int capacity = AbstractLinearHash.tableSizeFor(minCapacity);
        this.unsignedIndices = new int[capacity];
        CollectionUtils.systemFill(this.unsignedIndices, -1);
        this.currentInsertIndex = 0;
        this.minDataSize = capacity;
        this.data = new Object[capacity];
        this.deletedIndices = new boolean[capacity];
    }

    private static int findBinIndexFor(Object key, int hash, Object[] destination, BiPredicate<Object, Object> eqTest) {
        Object found;
        int mask = destination.length - 1;
        int addr = hash & mask;
        while ((found = destination[addr]) != null) {
            if (eqTest.test(key, found)) {
                return addr;
            }
            addr = addr + 1 & mask;
        }
        return addr;
    }

    private static int findEmptyBinIndex(int hash, Object[] destination) {
        int mask = destination.length - 1;
        int addr = hash & mask;
        while (destination[addr] != null) {
            addr = addr + 1 & mask;
        }
        return addr;
    }

    private static <K, E> int findBinIndex(K key, int hash, Object[] destination, BiPredicate<E, K> eqTest) {
        Object found;
        int mask = destination.length - 1;
        int addr = hash & mask;
        while ((found = destination[addr]) != null) {
            if (eqTest.test(found, key)) {
                return addr;
            }
            addr = addr + 1 & mask;
        }
        return addr;
    }

    private static int tableSizeFor(int dataSize) {
        int capacity = (int)((float)dataSize / 0.75f);
        int cap = Math.max(capacity, 2);
        int n = -1 >>> Integer.numberOfLeadingZeros(cap - 1);
        int ret = n + 1;
        assert (ret >= capacity);
        if (ret > 0x40000000) {
            throw new OutOfMemoryError();
        }
        return ret;
    }

    public E get(int addr) {
        return (E)(this.deletedIndices[addr] ? null : this.data[addr]);
    }

    private int findBinIndexFor(Object key, int hash, BiPredicate<Object, Object> eqTest) {
        return AbstractLinearHash.findBinIndexFor(key, hash, this.data, eqTest);
    }

    public <K> int findBinIndex(K key, int hash, BiPredicate<? super E, K> eqTest) {
        return AbstractLinearHash.findBinIndex(key, hash, this.data, eqTest);
    }

    public final boolean addVerbose(E element) {
        this.resize();
        BiPredicate<Object, Object> eq = this.getEqualsPredicate();
        int hash = this.getHashFunction().applyAsInt(element);
        int addr = this.findBinIndexFor(element, hash, eq);
        E old = this.saveDirect(element, addr);
        return old == null || !eq.test(element, old);
    }

    public final void addSilent(E element) {
        this.resize();
        this.addNoResize(element);
    }

    public final E add(E element) {
        this.resize();
        return this.addGetPrevious(element);
    }

    private void addNoResize(E element) {
        int hash = this.getHashFunction().applyAsInt(element);
        int addr = this.findBinIndexFor(element, hash, this.getEqualsPredicate());
        this.saveDirect(element, addr);
    }

    private E addGetPrevious(E element) {
        int hash = this.getHashFunction().applyAsInt(element);
        int addr = this.findBinIndexFor(element, hash, this.getEqualsPredicate());
        return this.saveDirect(element, addr);
    }

    public final E saveDirect(E element, int addr) {
        Object old = this.data[addr];
        this.data[addr] = element;
        if (old == null) {
            this.unsignedIndices[this.currentInsertIndex++] = addr;
            ++this.size;
        } else if (this.deletedIndices[addr]) {
            this.deletedIndices[addr] = false;
            --this.deletes;
            ++this.size;
        }
        return (E)old;
    }

    protected abstract ToIntFunction<Object> getHashFunction();

    protected abstract BiPredicate<Object, Object> getEqualsPredicate();

    public final int size() {
        return this.size;
    }

    final void deleteEntries(Predicate<E> predicate) {
        int initialDeletes = this.deletes;
        this.forEachDataEntry((E e, int i) -> {
            if (predicate.test(e)) {
                this.markDeleted(i);
            }
        });
        if (initialDeletes != this.deletes) {
            this.resize();
        }
    }

    public void forEachDataEntry(Consumer<E> consumer) {
        for (int i = 0; i < this.currentInsertIndex; ++i) {
            E obj = this.get(this.unsignedIndices[i]);
            if (obj == null) continue;
            consumer.accept(obj);
        }
    }

    private void forEachDataEntry(ObjIntConsumer<E> consumer) {
        for (int i = 0; i < this.currentInsertIndex; ++i) {
            int idx = this.unsignedIndices[i];
            E obj = this.get(idx);
            if (obj == null) continue;
            consumer.accept(obj, idx);
        }
    }

    protected void markDeleted(int addr) {
        if (!this.deletedIndices[addr]) {
            this.deletedIndices[addr] = true;
            ++this.deletes;
            --this.size;
        }
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        this.forEachDataEntry((E k) -> joiner.add(k.toString()));
        return joiner.toString();
    }

    public void clear() {
        CollectionUtils.systemFill(this.data, null);
        CollectionUtils.systemFill(this.deletedIndices, false);
        CollectionUtils.systemFill(this.unsignedIndices, -1);
        this.currentInsertIndex = 0;
        this.size = 0;
        this.deletes = 0;
    }

    boolean containsEntry(E e) {
        int addr = this.findBinIndexFor(e, this.getHashFunction().applyAsInt(e), this.getEqualsPredicate());
        return this.data[addr] != null && !this.deletedIndices[addr];
    }

    boolean removeEntry(Object e) {
        int addr = this.findBinIndexFor(e, this.getHashFunction().applyAsInt(e), this.getEqualsPredicate());
        return this.removeEntry(addr);
    }

    private boolean removeEntry(int addr) {
        if (this.data[addr] == null) {
            return false;
        }
        if (this.deletedIndices[addr]) {
            return false;
        }
        this.markDeleted(addr);
        return true;
    }

    @Override
    public ReIterator<E> iterator() {
        return new It();
    }

    public Stream<E> stream() {
        return Arrays.stream(this.unsignedIndices, 0, this.currentInsertIndex).filter(i -> !this.deletedIndices[i]).mapToObj(value -> this.data[value]);
    }

    public void resize() {
        int newDataSize;
        int upperBound = (int)((float)this.data.length * 0.75f);
        int lowerBound = (int)((float)this.data.length * 0.75f / 4.0f);
        if (this.size > upperBound) {
            this.rebuild(this.data.length * 2);
            return;
        }
        if (this.size < lowerBound && (newDataSize = Math.max(this.minDataSize, AbstractLinearHash.tableSizeFor(lowerBound * 2))) != this.data.length) {
            this.rebuild(newDataSize);
            return;
        }
        if (this.deletes > this.size && this.size > 2) {
            this.rebuild(this.data.length);
        }
    }

    private void rebuild(int newArrSize) {
        Object[] newData = new Object[newArrSize];
        int[] newUnsignedIndices = new int[newArrSize];
        int newCurrentInsertIndex = 0;
        ToIntFunction<Object> hashFunction = this.getHashFunction();
        for (int i = 0; i < this.currentInsertIndex; ++i) {
            E obj = this.get(this.unsignedIndices[i]);
            if (obj == null) continue;
            int addr = AbstractLinearHash.findEmptyBinIndex(hashFunction.applyAsInt(obj), newData);
            newData[addr] = obj;
            newUnsignedIndices[newCurrentInsertIndex++] = addr;
        }
        this.data = newData;
        this.deletes = 0;
        this.deletedIndices = new boolean[newArrSize];
        this.currentInsertIndex = newCurrentInsertIndex;
        this.unsignedIndices = newUnsignedIndices;
    }

    void assertStructure() {
        int indices = this.currentInsertIndex;
        int deletes = this.deletes;
        assert (indices == this.size + deletes) : "indices: " + indices + " size: " + this.size + ", deletes: " + deletes;
        assert (this.data.length >= this.minDataSize);
    }

    private final class It
    implements ReIterator<E> {
        int pos = 0;
        int nextIndex = this.computeNextIndex();
        int currentIndex = -1;

        private It() {
        }

        @Override
        public long reset() {
            this.pos = 0;
            this.nextIndex = this.computeNextIndex();
            return AbstractLinearHash.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        private int computeNextIndex() {
            while (this.pos < AbstractLinearHash.this.currentInsertIndex) {
                int idx = AbstractLinearHash.this.unsignedIndices[this.pos];
                if (AbstractLinearHash.this.deletedIndices[idx]) {
                    ++this.pos;
                    continue;
                }
                return idx;
            }
            return -1;
        }

        @Override
        public E next() {
            if (this.nextIndex < 0) {
                throw new NoSuchElementException();
            }
            ++this.pos;
            this.currentIndex = this.nextIndex;
            this.nextIndex = this.computeNextIndex();
            return AbstractLinearHash.this.data[this.currentIndex];
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new NoSuchElementException();
            }
            AbstractLinearHash.this.markDeleted(this.currentIndex);
        }
    }
}

