/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.function.Consumer;
import org.evrete.api.FieldReference;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.MemoryKeyCollection;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueHandle;
import org.evrete.api.ValueResolver;
import org.evrete.runtime.AbstractBetaConditionNode;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.BetaMemoryNode;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RuntimeBetaEvaluator;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.evaluation.BetaEvaluator;
import org.evrete.runtime.evaluation.EvaluatorWrapper;

public class BetaConditionNode
extends AbstractBetaConditionNode {
    static final BetaConditionNode[] EMPTY_ARRAY = new BetaConditionNode[0];
    private final MemoryKeyNode[] evaluationState;
    private final SourceMeta[] sourceMetas;
    private final CachingEvaluator cachingEvaluator;
    private final int[] descriptorIndices;

    BetaConditionNode(RuntimeRuleImpl rule, ConditionNodeDescriptor descriptor, BetaMemoryNode[] sources) {
        super(rule, descriptor, sources);
        EvaluatorWrapper[] childConditions;
        BetaEvaluator expression = descriptor.getExpression();
        ValueResolver valueResolver = ((AbstractRuleSession)rule.getRuntime()).memory.memoryFactory.getValueResolver();
        FactType[] allFactTypes = rule.getFactTypes();
        this.evaluationState = new MemoryKeyNode[allFactTypes.length];
        FactType[] types = this.getDescriptor().getTypes();
        this.descriptorIndices = new int[types.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            this.descriptorIndices[i2] = types[i2].getInRuleIndex();
        }
        RuntimeBetaEvaluator betaEvaluator = new RuntimeBetaEvaluator(this.getRuntime(), expression);
        this.cachingEvaluator = new CachingEvaluator(betaEvaluator);
        for (FactType type : allFactTypes) {
            MemoryKeyNode keyMeta = expression.getFactTypeMask().get(type) ? new ConditionMemoryKeyNode(type, valueResolver, expression, this.cachingEvaluator) : new MemoryKeyNode();
            this.evaluationState[type.getInRuleIndex()] = keyMeta;
        }
        this.sourceMetas = new SourceMeta[sources.length];
        for (int i3 = 0; i3 < sources.length; ++i3) {
            this.sourceMetas[i3] = new SourceMeta(sources[i3]);
        }
        for (EvaluatorWrapper e : childConditions = betaEvaluator.constituents()) {
            FieldReference[] refs = e.descriptor();
            ConditionValueReader[] valueReaders = new ConditionValueReader[refs.length];
            for (int i4 = 0; i4 < refs.length; ++i4) {
                FieldReference ref = refs[i4];
                Object factType = rule.resolveFactType(ref.type());
                int typeId = ((FactType)factType).getInRuleIndex();
                int fieldPosition = ((FactType)factType).findFieldPosition(ref.field());
                valueReaders[i4] = new ConditionValueReader(this.evaluationState, typeId, fieldPosition);
            }
            e.setStateValues(i -> valueReaders[i].get());
        }
    }

    public static void forEachConditionNode(BetaConditionNode node, Consumer<BetaConditionNode> consumer) {
        consumer.accept(node);
        for (BetaMemoryNode parent : node.getSources()) {
            if (!parent.getDescriptor().isConditionNode()) continue;
            BetaConditionNode.forEachConditionNode((BetaConditionNode)parent, consumer);
        }
    }

    @Override
    public void commitDelta() {
        throw new UnsupportedOperationException();
    }

    public void computeDelta(boolean deltaOnly) {
        this.forEachKeyMode(0, false, false, new KeyMode[this.sourceMetas.length], deltaOnly);
    }

    private void forEachKeyMode(int sourceIndex, boolean hasDelta, boolean hasKnownKeys, KeyMode[] modes, boolean deltaOnly) {
        for (KeyMode mode : KeyMode.values()) {
            boolean newHasDelta = hasDelta || mode.isDelta();
            boolean newHasKnownKeys = hasKnownKeys || mode == KeyMode.OLD_NEW;
            modes[sourceIndex] = mode;
            if (sourceIndex == this.sourceMetas.length - 1) {
                if (!newHasDelta && deltaOnly) continue;
                KeyMode destinationMode = newHasKnownKeys ? KeyMode.OLD_NEW : KeyMode.NEW_NEW;
                this.forEachModeSelection(destinationMode, modes);
                continue;
            }
            this.forEachKeyMode(sourceIndex + 1, newHasDelta, newHasKnownKeys, modes, deltaOnly);
        }
    }

    private void forEachModeSelection(KeyMode destinationMode, KeyMode[] sourceModes) {
        MemoryKeyCollection destination = this.getStore(destinationMode);
        for (int i = 0; i < this.sourceMetas.length; ++i) {
            if (this.sourceMetas[i].setIterator(sourceModes[i])) continue;
            return;
        }
        for (MemoryKeyNode meta : this.evaluationState) {
            meta.clear();
        }
        this.forEachMemoryKey(0, destination);
    }

    private void forEachMemoryKey(int sourceIndex, MemoryKeyCollection destination) {
        SourceMeta meta = this.sourceMetas[sourceIndex];
        ReIterator<MemoryKey> it = meta.currentIterator;
        if (it.reset() == 0L) {
            return;
        }
        if (sourceIndex == this.sourceMetas.length - 1) {
            while (it.hasNext()) {
                if (!this.setState(it, meta.factTypeIndices) || !this.cachingEvaluator.test()) continue;
                for (int ruleIndex : this.descriptorIndices) {
                    destination.add(this.evaluationState[ruleIndex].currentKey);
                }
            }
        } else {
            while (it.hasNext()) {
                if (!this.setState(it, meta.factTypeIndices)) continue;
                this.forEachMemoryKey(sourceIndex + 1, destination);
            }
        }
    }

    private boolean setState(ReIterator<MemoryKey> it, int[] indices) {
        boolean ret = true;
        for (int idx : indices) {
            MemoryKey key = (MemoryKey)it.next();
            ret &= key.getMetaValue() != -1;
            this.evaluationState[idx].setKey(key);
        }
        return ret;
    }

    void forEachConditionNode(Consumer<BetaConditionNode> consumer) {
        BetaConditionNode.forEachConditionNode(this, consumer);
    }

    private static class ConditionValueReader {
        private final MemoryKeyNode[] evaluationState;
        private final int type;
        private final int field;

        ConditionValueReader(MemoryKeyNode[] evaluationState, int type, int field) {
            this.evaluationState = evaluationState;
            this.type = type;
            this.field = field;
        }

        Object get() {
            return this.evaluationState[this.type].value(this.field);
        }
    }

    private static class CachingEvaluator {
        private final RuntimeBetaEvaluator delegate;
        private boolean cached = false;
        private boolean lastResponse;

        CachingEvaluator(RuntimeBetaEvaluator delegate) {
            this.delegate = delegate;
        }

        void valuesChanged() {
            this.cached = false;
        }

        boolean test() {
            if (!this.cached) {
                this.lastResponse = this.delegate.test();
                this.cached = true;
            }
            return this.lastResponse;
        }
    }

    private static class ConditionFieldNode
    extends FieldNode {
        private final CachingEvaluator evaluator;

        ConditionFieldNode(ValueResolver valueResolver, CachingEvaluator evaluator) {
            super(valueResolver);
            this.evaluator = evaluator;
        }

        @Override
        void update(ValueHandle handle) {
            if (handle != this.lastHandle) {
                this.value = this.valueResolver.getValue(handle);
                this.lastHandle = handle;
                this.evaluator.valuesChanged();
            }
        }
    }

    private static class FieldNode {
        final ValueResolver valueResolver;
        Object value;
        ValueHandle lastHandle;

        FieldNode(ValueResolver valueResolver) {
            this.valueResolver = valueResolver;
        }

        final void clear() {
            this.lastHandle = null;
            this.value = null;
        }

        void update(ValueHandle handle) {
            if (handle != this.lastHandle) {
                this.value = this.valueResolver.getValue(handle);
                this.lastHandle = handle;
            }
        }
    }

    private static class ConditionMemoryKeyNode
    extends MemoryKeyNode {
        private final FieldNode[] fieldNodes;

        ConditionMemoryKeyNode(FactType type, ValueResolver valueResolver, BetaEvaluator evaluator, CachingEvaluator cachingEvaluator) {
            ActiveField[] fields = type.getMemoryAddress().fields().getFields();
            this.fieldNodes = new FieldNode[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                ActiveField field = fields[i];
                FieldNode fieldNode = evaluator.evaluatesField(field) ? new ConditionFieldNode(valueResolver, cachingEvaluator) : new FieldNode(valueResolver);
                this.fieldNodes[i] = fieldNode;
            }
        }

        @Override
        void clear() {
            super.clear();
            for (FieldNode fn : this.fieldNodes) {
                fn.clear();
            }
        }

        @Override
        Object value(int fieldIndex) {
            return this.fieldNodes[fieldIndex].value;
        }

        @Override
        public void setKey(MemoryKey key) {
            if (key != this.currentKey) {
                for (int i = 0; i < this.fieldNodes.length; ++i) {
                    this.fieldNodes[i].update(key.get(i));
                }
                this.currentKey = key;
            }
        }
    }

    private static class MemoryKeyNode {
        MemoryKey currentKey;

        MemoryKeyNode() {
        }

        void clear() {
            this.currentKey = null;
        }

        void setKey(MemoryKey key) {
            this.currentKey = key;
        }

        Object value(int fieldIndex) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SourceMeta {
        final BetaMemoryNode source;
        final int[] factTypeIndices;
        ReIterator<MemoryKey> currentIterator;

        SourceMeta(BetaMemoryNode source) {
            this.source = source;
            FactType[] factTypes = source.getDescriptor().getTypes();
            this.factTypeIndices = new int[factTypes.length];
            for (int i = 0; i < factTypes.length; ++i) {
                this.factTypeIndices[i] = factTypes[i].getInRuleIndex();
            }
        }

        boolean setIterator(KeyMode mode) {
            this.currentIterator = this.source.iterator(mode);
            return this.currentIterator.reset() > 0L;
        }
    }
}

