/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Iterator;
import java.util.Objects;
import org.evrete.api.FactHandle;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.FactStorage;
import org.evrete.api.KeyedFactStorage;
import org.evrete.api.Type;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.KeyMemoryBucket;
import org.evrete.runtime.MemoryComponent;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.evaluation.MemoryAddress;

public class TypeMemoryBase
extends MemoryComponent
implements Iterable<KeyMemoryBucket> {
    final FactStorage<FactRecord> factStorage;
    final Type<?> type;
    private final ArrayOf<KeyMemoryBucket> memoryBuckets = new ArrayOf<KeyMemoryBucket>(KeyMemoryBucket.class);

    TypeMemoryBase(SessionMemory sessionMemory, int type) {
        super(sessionMemory);
        String identityMethod;
        Type t = this.runtime.getTypeResolver().getType(type);
        this.type = t;
        switch (identityMethod = this.configuration.getProperty("evrete.core.fact-identity-strategy")) {
            case "equals": {
                this.factStorage = this.memoryFactory.newFactStorage(t, FactRecord.class, (o1, o2) -> Objects.equals(o1.instance, o2.instance));
                break;
            }
            case "identity": {
                this.factStorage = this.memoryFactory.newFactStorage(t, FactRecord.class, (o1, o2) -> o1.instance == o2.instance);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid identity method '" + identityMethod + "' in the configuration. Expected values are '" + "equals" + "' or '" + "identity" + "'");
            }
        }
    }

    FactRecord getStoredRecord(FactHandle handle) {
        return this.factStorage.getFact(handle);
    }

    public boolean factExists(FactHandleVersioned handle) {
        FactRecord fact = this.factStorage.getFact(handle.getHandle());
        return fact != null && fact.getVersion() == handle.getVersion();
    }

    public FactStorage<FactRecord> getFactStorage() {
        return this.factStorage;
    }

    @Override
    public Iterator<KeyMemoryBucket> iterator() {
        return this.memoryBuckets.iterator();
    }

    public Type<?> getType() {
        return this.type;
    }

    @Override
    protected void clearLocalData() {
        this.factStorage.clear();
    }

    void destroy() {
        this.memoryBuckets.clear();
    }

    void commitBuffer() {
        for (KeyMemoryBucket bucket : (KeyMemoryBucket[])this.memoryBuckets.data) {
            bucket.commitBuffer();
        }
    }

    public ArrayOf<KeyMemoryBucket> getMemoryBuckets() {
        return this.memoryBuckets;
    }

    KeyMemoryBucket touchMemory(MemoryAddress address) {
        return this.getCreate(address);
    }

    private KeyMemoryBucket getCreate(MemoryAddress address) {
        return this.memoryBuckets.computeIfAbsent(address.getBucketIndex(), k -> KeyMemoryBucket.factory(this, address));
    }

    public KeyedFactStorage get(MemoryAddress bucket) {
        return this.getMemoryBucket(bucket).getFieldData();
    }

    KeyMemoryBucket getMemoryBucket(MemoryAddress bucket) {
        int bucketIndex = bucket.getBucketIndex();
        if (bucketIndex >= ((KeyMemoryBucket[])this.memoryBuckets.data).length) {
            throw new IllegalArgumentException("No alpha bucket created for " + bucket);
        }
        KeyMemoryBucket storage = ((KeyMemoryBucket[])this.memoryBuckets.data)[bucketIndex];
        if (storage == null) {
            throw new IllegalArgumentException("No alpha bucket created for " + bucket);
        }
        return storage;
    }
}

