/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.collections.ArrayOf;
import org.evrete.spi.minimal.Const;
import org.evrete.spi.minimal.TypeFieldImpl;

class TypeImpl<T>
implements Type<T> {
    static final String THIS_FIELD_NAME = "this";
    private static final int THIS_FIELD_ID = 0;
    private final int id;
    private final String name;
    private final Class<T> javaType;
    private final Map<String, TypeFieldImpl> fieldMap = new HashMap<String, TypeFieldImpl>();
    private final ArrayOf<TypeFieldImpl> fieldsArray;

    TypeImpl(String name, int id, Class<T> javaType) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(javaType);
        this.javaType = javaType;
        this.name = name;
        this.id = id;
        this.fieldsArray = new ArrayOf<TypeFieldImpl>(TypeFieldImpl.class);
        TypeFieldImpl thisField = new TypeFieldImpl(0, this, THIS_FIELD_NAME, javaType, o -> o);
        this.save(thisField);
    }

    private TypeImpl(TypeImpl<T> other) {
        this.fieldMap.putAll(other.fieldMap);
        this.fieldsArray = new ArrayOf<TypeFieldImpl>(TypeFieldImpl.class);
        this.javaType = other.javaType;
        this.name = other.name;
        this.id = other.id;
        for (Map.Entry<String, TypeFieldImpl> entry : other.fieldMap.entrySet()) {
            TypeFieldImpl f = entry.getValue().copy(this);
            this.save(f);
        }
    }

    private static ValueReader resolve(MethodHandles.Lookup lookup, Class<?> clazz, String prop) {
        MethodHandle handle = null;
        for (Field field : clazz.getFields()) {
            if (!field.getName().equals(prop) || Modifier.isStatic(field.getModifiers())) continue;
            try {
                handle = lookup.unreflectGetter(field);
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (handle != null) {
            return new ValueReader(handle);
        }
        for (MethodMeta methodMeta : MethodMeta.values()) {
            String methodName = methodMeta.buildName(prop);
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(methodName) || !methodMeta.validMethod(method)) continue;
                try {
                    handle = lookup.unreflect(method);
                    break;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            if (handle == null) continue;
            return new ValueReader(handle);
        }
        return null;
    }

    private static String capitalizeFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private void save(TypeFieldImpl f) {
        this.fieldMap.put(f.getName(), f);
        this.fieldsArray.set(f.getId(), f);
    }

    @Override
    public TypeField getField(int id) {
        return this.fieldsArray.get(id);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public TypeImpl<T> copyOf() {
        return new TypeImpl<T>(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeImpl type = (TypeImpl)o;
        return this.name.equals(type.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeField getField(String name) {
        TypeField field = this.fieldMap.get(name);
        if (field == null) {
            TypeImpl typeImpl = this;
            synchronized (typeImpl) {
                field = this.fieldMap.get(name);
                if (field == null) {
                    field = this.inspectClass(name);
                }
            }
        }
        return field;
    }

    @Override
    public <V> TypeField declareField(String name, Class<V> type, Function<T, V> function) {
        return this.innerDeclare(name, type, o -> function.apply(o));
    }

    @Override
    public final Class<T> getJavaType() {
        return this.javaType;
    }

    @Override
    public final Collection<TypeField> getDeclaredFields() {
        return Collections.unmodifiableCollection(this.fieldMap.values());
    }

    public String toString() {
        return "{name='" + this.name + '\'' + ", javaType='" + this.javaType.getName() + '\'' + '}';
    }

    private synchronized TypeField innerDeclare(String name, Class<?> type, Function<Object, ?> function) {
        Const.assertName(name);
        TypeFieldImpl field = this.fieldMap.get(name);
        if (field == null) {
            int fieldId = this.fieldMap.size();
            field = new TypeFieldImpl(fieldId, this, name, type, function);
            this.fieldMap.put(name, field);
            this.fieldsArray.set(fieldId, field);
        } else {
            field.setFunction(function);
        }
        return field;
    }

    private TypeField inspectClass(String dottedProp) {
        String[] parts = dottedProp.split("\\.");
        ArrayOf<ValueReader> getters = new ArrayOf<ValueReader>(ValueReader.class);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class<Object> valueType = this.javaType;
        for (String part : parts) {
            Const.assertName(part);
            ValueReader reader = TypeImpl.resolve(lookup, valueType, part);
            if (reader == null) {
                return null;
            }
            valueType = reader.valueType();
            getters.append(reader);
        }
        Function<Object, Object> func = ((ValueReader[])getters.data).length == 1 ? new AtomicFunction(((ValueReader[])getters.data)[0]) : new NestedFunction((ValueReader[])getters.data);
        return this.innerDeclare(dottedProp, valueType, func);
    }

    private static final class ValueReader {
        private final MethodHandle handle;

        ValueReader(MethodHandle handle) {
            this.handle = handle;
        }

        Object read(Object o) throws Throwable {
            return this.handle.invoke(o);
        }

        Class<?> valueType() {
            return this.handle.type().returnType();
        }
    }

    private static class AtomicFunction
    implements Function<Object, Object> {
        private final ValueReader reader;

        AtomicFunction(ValueReader reader) {
            this.reader = reader;
        }

        @Override
        public Object apply(Object o) {
            try {
                return this.reader.read(o);
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }

    private static class NestedFunction
    implements Function<Object, Object> {
        private final ValueReader[] readers;

        NestedFunction(ValueReader[] readers) {
            this.readers = readers;
        }

        @Override
        public Object apply(Object o) {
            try {
                Object current = o;
                for (ValueReader reader : this.readers) {
                    if ((current = reader.read(current)) != null) continue;
                    return null;
                }
                return current;
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }

    private static enum MethodMeta {
        DEFAULT("get", true, false),
        BOOL("is", true, true),
        RAW("", false, false);

        private final String prefix;
        private final boolean capitalizeFirst;
        private final boolean requireBoolean;

        private MethodMeta(String prefix, boolean capitalizeFirst, boolean requireBoolean) {
            this.prefix = prefix;
            this.capitalizeFirst = capitalizeFirst;
            this.requireBoolean = requireBoolean;
        }

        String buildName(String prop) {
            if (this.capitalizeFirst) {
                return this.prefix + TypeImpl.capitalizeFirst(prop);
            }
            return this.prefix + prop;
        }

        boolean validMethod(Method method) {
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (method.getParameterCount() > 0) {
                return false;
            }
            Class<?> retType = method.getReturnType();
            if (this.requireBoolean) {
                return retType.equals(Boolean.TYPE) || retType.equals(Boolean.class);
            }
            return !retType.equals(Void.TYPE);
        }
    }
}

