/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.util.BitSet;
import java.util.function.ToIntFunction;
import org.evrete.runtime.FactType;
import org.evrete.runtime.evaluation.MemoryAddress;

public final class Mask<T> {
    public static final BitSet EMPTY = new BitSet();
    private final BitSet delegate = new BitSet();
    private final ToIntFunction<T> intMapper;

    private Mask(ToIntFunction<T> intMapper) {
        this.intMapper = intMapper;
    }

    public static Mask<MemoryAddress> addressMask() {
        return new Mask<MemoryAddress>(MemoryAddress::getId);
    }

    public static Mask<FactType> factTypeMask() {
        return new Mask<FactType>(FactType::getInRuleIndex);
    }

    public void or(Mask<T> other) {
        this.delegate.or(other.delegate);
    }

    public void clear() {
        this.delegate.clear();
    }

    public void set(T obj) {
        this.delegate.set(this.intMapper.applyAsInt(obj));
    }

    public boolean get(T obj) {
        return this.delegate.get(this.intMapper.applyAsInt(obj));
    }

    public int cardinality() {
        return this.delegate.cardinality();
    }

    public boolean intersects(Mask<T> other) {
        return this.delegate.intersects(other.delegate);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

