/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.tools.JavaFileObject;
import org.evrete.util.compiler.CompiledClass;

public class ServiceClassLoader
extends SecureClassLoader {
    private static final Logger LOGGER = Logger.getLogger(ServiceClassLoader.class.getName());
    private final Map<String, byte[]> resources = new HashMap<String, byte[]>();
    private final ProtectionDomain protectionDomain;
    private final List<CompiledClass> localCompiledClasses = new ArrayList<CompiledClass>();

    public ServiceClassLoader(ClassLoader parent, ProtectionDomain protectionDomain) {
        super(parent);
        Objects.requireNonNull(protectionDomain);
        this.protectionDomain = protectionDomain;
    }

    public Class<?> buildClass(byte[] bytes) {
        Class<?> cl = this.defineClass(null, bytes, 0, bytes.length, this.protectionDomain);
        this.localCompiledClasses.add(new CompiledClass(cl, bytes));
        return cl;
    }

    public void addResource(String name, byte[] bytes) {
        this.resources.put(name, bytes);
    }

    @Override
    protected URL findResource(String name) {
        if (!this.resources.isEmpty()) {
            LOGGER.warning("Redirecting the findResource(String name) call to parent classloader. To access this classloader's resources, please use the getResourceAsStream() method instead");
        }
        return super.findResource(name);
    }

    Collection<JavaFileObject> getCompiledClasses(String packageName) {
        ArrayList<JavaFileObject> col = new ArrayList<JavaFileObject>();
        for (ClassLoader current = this; current != null; current = current.getParent()) {
            if (!(current instanceof ServiceClassLoader)) continue;
            ServiceClassLoader scl = current;
            for (CompiledClass cc : scl.localCompiledClasses) {
                if (!cc.getPackageName().equals(packageName)) continue;
                col.add(cc);
            }
        }
        return col;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        if (!this.resources.isEmpty()) {
            LOGGER.warning("Redirecting the findResources(String name) call to parent classloader. To access this classloader's resources, please use the getResourceAsStream() method instead");
        }
        return super.findResources(name);
    }

    @Override
    public URL getResource(String name) {
        LOGGER.warning("Redirecting the getResource(String name) call to parent classloader. To access this classloader's resources, please use the getResourceAsStream() method instead");
        return super.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] bytes = this.resources.get(name);
        if (bytes == null) {
            return super.getResourceAsStream(name);
        }
        return new ByteArrayInputStream(bytes);
    }
}

