/*
 * Decompiled with CFR 0.152.
 */
package org.evrete;

import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.EnumMap;
import org.evrete.api.RuleScope;

public class SourceSecurity {
    private static final CodeSource CODE_SOURCE = new CodeSource(null, (CodeSigner[])null);
    private final EnumMap<RuleScope, ProtectionDomain> protectionDomains = new EnumMap(RuleScope.class);
    private final EnumMap<RuleScope, Permissions> permissions = new EnumMap(RuleScope.class);

    SourceSecurity() {
        for (RuleScope scope : RuleScope.values()) {
            this.permissions.put(scope, new Permissions());
        }
    }

    public SourceSecurity addPermission(RuleScope scope, Permission permission) {
        this.permissions.get((Object)scope).add(permission);
        if (scope == RuleScope.BOTH) {
            this.addPermission(RuleScope.LHS, permission);
            this.addPermission(RuleScope.RHS, permission);
        }
        return this;
    }

    public ProtectionDomain getProtectionDomain(RuleScope scope) {
        return this.protectionDomains.computeIfAbsent(scope, s -> {
            Permissions perms = this.permissions.get(s);
            return new ProtectionDomain(CODE_SOURCE, perms);
        });
    }
}

