/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Function;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.NamedType;
import org.evrete.api.TypeField;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.builder.AbstractLhsBuilder;
import org.evrete.runtime.evaluation.BetaEvaluator;
import org.evrete.runtime.evaluation.EvaluatorFactory;
import org.evrete.util.MapFunction;
import org.evrete.util.NextIntSupplier;

abstract class AbstractLhsDescriptor {
    private final FactType[] factTypes;
    private final RhsFactGroupDescriptor[] allFactGroups;

    AbstractLhsDescriptor(AbstractRuntime<?, ?> runtime, AbstractLhsBuilder<?, ?> lhsBuilder, NextIntSupplier factIdGenerator, MapFunction<NamedType, FactType> typeMapping) {
        Set<NamedType> declaredTypes = lhsBuilder.getDeclaredFactTypes();
        HashSet<FactType> keyedFactTypes = new HashSet<FactType>();
        ArrayList<FactType> plainFactTypes = new ArrayList<FactType>();
        LinkedList<FactType> allFactTypes = new LinkedList<FactType>();
        for (NamedType namedType : declaredTypes) {
            Set<EvaluatorHandle> alphaConditions = lhsBuilder.getAlphaConditions(namedType);
            Set<TypeField> fields = lhsBuilder.getBetaFields(namedType);
            FactType factType = runtime.buildFactType(namedType, fields, alphaConditions, factIdGenerator.next());
            typeMapping.putNew(namedType, factType);
            if (factType.getMemoryAddress().fields().size() == 0) {
                plainFactTypes.add(factType);
            } else {
                keyedFactTypes.add(factType);
            }
            allFactTypes.add(factType);
        }
        this.factTypes = allFactTypes.toArray(FactType.ZERO_ARRAY);
        ConditionNodeDescriptor[] finalNodes = AbstractLhsDescriptor.findBestAllocation(lhsBuilder, typeMapping);
        ArrayList<RhsFactGroupDescriptor> allFactGroups = new ArrayList<RhsFactGroupDescriptor>();
        for (ConditionNodeDescriptor finalNode : finalNodes) {
            RhsFactGroupDescriptor descriptor = new RhsFactGroupDescriptor(finalNode);
            allFactGroups.add(descriptor);
            Arrays.asList(descriptor.getTypes()).forEach(keyedFactTypes::remove);
        }
        assert (keyedFactTypes.isEmpty());
        if (!plainFactTypes.isEmpty()) {
            allFactGroups.add(new RhsFactGroupDescriptor(plainFactTypes));
        }
        this.allFactGroups = allFactGroups.toArray(RhsFactGroupDescriptor.ZERO_ARRAY);
    }

    private static ConditionNodeDescriptor[] findBestAllocation(AbstractLhsBuilder<?, ?> lhsBuilder, MapFunction<NamedType, FactType> mapping) {
        HashSet<EvaluatorHandle> betaConditions = new HashSet<EvaluatorHandle>(lhsBuilder.getBetaConditions());
        if (betaConditions.isEmpty()) {
            return ConditionNodeDescriptor.ZERO_ARRAY;
        }
        ArrayList<BetaEvaluator> evaluators = new ArrayList<BetaEvaluator>(EvaluatorFactory.flattenEvaluators(betaConditions, mapping));
        if (evaluators.isEmpty()) {
            throw new IllegalStateException();
        }
        double maxComplexity = Double.MIN_VALUE;
        double minComplexity = Double.MAX_VALUE;
        HashSet<FactType> betaTypes = new HashSet<FactType>();
        for (BetaEvaluator betaEvaluator : evaluators) {
            double complexity = betaEvaluator.getComplexity();
            if (complexity <= 0.0) {
                throw new IllegalStateException("Complexity must be a positive value");
            }
            if (complexity > maxComplexity) {
                maxComplexity = complexity;
            }
            if (complexity < minComplexity) {
                minComplexity = complexity;
            }
            betaTypes.addAll(betaEvaluator.factTypes());
        }
        HashMap<BetaEvaluator, Double> minMaxComplexities = new HashMap<BetaEvaluator, Double>();
        for (BetaEvaluator g : evaluators) {
            double newComplexity = 1.0 + (g.getComplexity() - minComplexity) / (maxComplexity - minComplexity);
            minMaxComplexities.put(g, newComplexity * (double)g.getTotalTypesInvolved());
        }
        evaluators.sort(Comparator.comparingDouble(minMaxComplexities::get).thenComparing((Function<BetaEvaluator, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/evrete/runtime/evaluation/BetaEvaluator;)Ljava/lang/String;)()));
        Collection<ConditionNodeDescriptor> collection = ConditionNodeDescriptor.allocateConditions(betaTypes, evaluators);
        return collection.toArray(ConditionNodeDescriptor.ZERO_ARRAY);
    }

    RhsFactGroupDescriptor[] getAllFactGroups() {
        return this.allFactGroups;
    }

    public FactType[] getFactTypes() {
        return this.factTypes;
    }

    public String toString() {
        return "{factGroups=" + Arrays.toString(this.allFactGroups) + '}';
    }
}

