/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.evrete.AbstractRule;
import org.evrete.api.NamedType;
import org.evrete.api.RuleScope;
import org.evrete.api.Type;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.FactType;
import org.evrete.util.NamedTypeImpl;

public abstract class AbstractRuntimeRule<T extends FactType>
extends AbstractRule {
    final T[] factTypes;
    private final AbstractRuntime<?, ?> runtime;
    private final Map<String, T> typeMapping = new HashMap<String, T>();

    AbstractRuntimeRule(AbstractRuntime<?, ?> runtime, AbstractRule other, T[] factTypes) {
        this(runtime, other, other.getName(), other.getSalience(), (FactType[])factTypes);
    }

    AbstractRuntimeRule(AbstractRuntime<?, ?> runtime, AbstractRule other, String ruleName, int salience, T[] factTypes) {
        super(other, ruleName, salience);
        this.runtime = runtime;
        this.factTypes = factTypes;
        for (T factType : factTypes) {
            if (this.typeMapping.put(((FactType)factType).getName(), factType) == null) continue;
            throw new IllegalStateException();
        }
        this.appendImports(runtime.getImports());
        this.setRhs(this.getLiteralRhs());
    }

    @Override
    public NamedType resolve(String var) {
        FactType factType = (FactType)this.typeMapping.get(var);
        Type t = this.runtime.getTypeResolver().getType(factType.type());
        return new NamedTypeImpl(t, factType.getName());
    }

    T resolveFactType(NamedType type) {
        return (T)((FactType)this.typeMapping.get(type.getName()));
    }

    public T[] getFactTypes() {
        return this.factTypes;
    }

    @Override
    public final void setRhs(String literalRhs) {
        LinkedList<NamedType> namedTypes = new LinkedList<NamedType>();
        for (T factType : this.factTypes) {
            namedTypes.add(this.resolve(((FactType)factType).getName()));
        }
        if (literalRhs != null) {
            this.setRhs(this.runtime.compile(literalRhs, namedTypes, this.getImports(), RuleScope.BOTH, RuleScope.RHS));
        }
    }
}

