/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util.compiler;

import java.util.Collections;
import java.util.Objects;
import java.util.StringJoiner;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.evrete.util.compiler.CompilationException;
import org.evrete.util.compiler.FileManager;
import org.evrete.util.compiler.JavaSource;
import org.evrete.util.compiler.ServiceClassLoader;

public class SourceCompiler {
    private final JavaCompiler compiler = Objects.requireNonNull(ToolProvider.getSystemJavaCompiler(), "No Java compiler provided by this platform");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class<?> compile(String source, ServiceClassLoader classLoader) throws CompilationException {
        JavaCompiler javaCompiler = this.compiler;
        synchronized (javaCompiler) {
            byte[] classBytes;
            FileManager<?> fileManager = FileManager.instance(this.compiler, classLoader);
            try {
                classBytes = this.compileInner(fileManager, source, Collections.singletonList("-parameters"));
            }
            catch (Exception e) {
                classBytes = this.compileInner(fileManager, source, null);
            }
            return classLoader.buildClass(classBytes);
        }
    }

    private byte[] compileInner(FileManager<?> fileManager, String source, Iterable<String> options) throws CompilationException {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        boolean success = this.compiler.getTask(null, fileManager, diagnostics, options, null, JavaSource.task(source)).call();
        if (!success) {
            StringJoiner errors = new StringJoiner(", ");
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                errors.add(diagnostic.toString());
            }
            throw new CompilationException("Compilation error(s): " + errors, source);
        }
        return fileManager.getBytes();
    }
}

