/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collector;
import org.evrete.api.Action;
import org.evrete.api.ActivationManager;
import org.evrete.api.FactHandle;
import org.evrete.api.MemoryFactory;
import org.evrete.api.Rule;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuleSession;
import org.evrete.api.RuntimeRule;
import org.evrete.api.SessionLifecycleListener;
import org.evrete.api.Type;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.AtomicMemoryAction;
import org.evrete.runtime.FactActionBuffer;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.FactTuple;
import org.evrete.runtime.FactType;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.RuntimeRules;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.async.RuleHotDeploymentTask;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.SessionCollector;

abstract class AbstractRuleSession<S extends RuleSession<S>>
extends AbstractRuntime<RuntimeRule, S>
implements RuleSession<S> {
    private static final Logger LOGGER = Logger.getLogger(AbstractRuleSession.class.getName());
    private final boolean warnUnknownTypes;
    final List<SessionLifecycleListener> lifecycleListeners = new ArrayList<SessionLifecycleListener>();
    final SessionMemory memory;
    final RuntimeRules ruleStorage;
    private final KnowledgeRuntime knowledge;
    ActivationManager activationManager;
    private BooleanSupplier fireCriteria = () -> true;
    private volatile boolean active = true;
    final FactActionBuffer actionBuffer;

    protected abstract S thisInstance();

    AbstractRuleSession(KnowledgeRuntime knowledge) {
        super(knowledge);
        this.knowledge = knowledge;
        this.warnUnknownTypes = knowledge.getConfiguration().getAsBoolean("evrete.core.warn-unknown-types");
        this.activationManager = this.newActivationManager();
        this.actionBuffer = this.newActionBuffer();
        this.ruleStorage = new RuntimeRules();
        MemoryFactory memoryFactory = this.getService().getMemoryFactoryProvider().instance(this);
        this.memory = new SessionMemory(this, memoryFactory);
        for (RuleDescriptor descriptor : knowledge.getRules()) {
            this.deployRule(descriptor, false);
        }
    }

    FactActionBuffer newActionBuffer() {
        return new FactActionBuffer(this.getConfiguration().getAsInteger("evrete.core.insert-buffer-size", 4096));
    }

    boolean fireCriteriaMet() {
        return this.fireCriteria.getAsBoolean();
    }

    private void applyFireCriteria(BooleanSupplier fireCriteria) {
        this.fireCriteria = fireCriteria;
    }

    @Override
    public S setActivationManager(ActivationManager activationManager) {
        this.activationManager = activationManager;
        return this.thisInstance();
    }

    @Override
    public S setExecutionPredicate(BooleanSupplier criteria) {
        this.applyFireCriteria(criteria);
        return this.thisInstance();
    }

    @Override
    public final ActivationManager getActivationManager() {
        return this.activationManager;
    }

    @Override
    public final S addEventListener(SessionLifecycleListener listener) {
        this.lifecycleListeners.add(listener);
        return this.thisInstance();
    }

    @Override
    public final S removeEventListener(SessionLifecycleListener listener) {
        this.lifecycleListeners.remove(listener);
        return this.thisInstance();
    }

    public final <T> T getFact(FactHandle handle) {
        FactRecord rec = this.getFactRecord(handle);
        return (T)(rec == null ? null : rec.instance);
    }

    final FactRecord getFactRecord(FactHandle handle) {
        AtomicMemoryAction bufferedAction = this.actionBuffer.find(handle);
        FactRecord found = bufferedAction == null ? this.memory.get(handle.getTypeId()).getFactRecord(handle) : (bufferedAction.action == Action.RETRACT ? null : bufferedAction.getDelta().getLatest());
        return found;
    }

    @Override
    final void _assertActive() {
        if (!this.active) {
            throw new IllegalStateException("Session has been closed");
        }
    }

    @Override
    public KnowledgeRuntime getParentContext() {
        return this.knowledge;
    }

    private synchronized RuntimeRule deployRule(RuleDescriptor descriptor, boolean hotDeployment) {
        for (FactType factType : descriptor.getLhs().getFactTypes()) {
            TypeMemory tm = this.memory.getCreateUpdate(factType.type());
            tm.touchMemory(factType.getMemoryAddress());
        }
        RuntimeRuleImpl rule = this.ruleStorage.addRule(descriptor, this);
        if (hotDeployment) {
            this.getExecutor().invoke(new RuleHotDeploymentTask(rule));
        }
        this.reSortRules();
        return rule;
    }

    private void reSortRules() {
        this.ruleStorage.sort(this.getRuleComparator());
    }

    @Override
    public RuntimeRule compileRule(RuleBuilder<?> builder) {
        RuleDescriptor rd = this.compileRuleBuilder(builder);
        return this.deployRule(rd, true);
    }

    @Override
    public void setRuleComparator(Comparator<Rule> ruleComparator) {
        super.setRuleComparator(ruleComparator);
        this.reSortRules();
    }

    public final SessionMemory getMemory() {
        return this.memory;
    }

    final void forEachFactFull(BiConsumer<FactHandle, Object> consumer) {
        HashSet buffered = new HashSet();
        this.actionBuffer.forEach(a -> {
            FactHandle handle = a.handle;
            buffered.add(handle);
            if (a.action != Action.RETRACT) {
                consumer.accept(handle, a.getDelta().getLatest().instance);
            }
        });
        this.forEachFactCommitted((handle, o) -> {
            if (!buffered.contains(handle)) {
                consumer.accept((FactHandle)handle, o);
            }
        });
    }

    private void forEachFactCommitted(BiConsumer<FactHandle, Object> consumer) {
        for (TypeMemory tm : this.memory) {
            tm.forEachFact(consumer);
        }
    }

    <T> void forEachFactFull(String type, Consumer<T> consumer) {
        Type t = this.getTypeResolver().getType(type);
        if (t == null) {
            LOGGER.warning("Type not found: '" + type + "'");
            return;
        }
        HashSet buffered = new HashSet();
        this.actionBuffer.forEach(t, a -> {
            FactHandle handle = a.handle;
            buffered.add(handle);
            if (a.action != Action.RETRACT) {
                consumer.accept(a.getDelta().getLatest().instance);
            }
        });
        this.forEachFactCommitted(t.getId(), (handle, o) -> {
            if (!buffered.contains(handle)) {
                consumer.accept(o);
            }
        });
    }

    private <T> void forEachFactCommitted(int t, BiConsumer<FactHandle, T> consumer) {
        this.memory.getCreateUpdate(t).forEachFact((handle, o) -> consumer.accept((FactHandle)handle, (Object)o));
    }

    @Override
    public <T> Collector<T, ?, S> asCollector() {
        return new SessionCollector(this.thisInstance());
    }

    @Override
    public final RuntimeRule getRule(String name) {
        return (RuntimeRule)this.ruleStorage.get(name);
    }

    @Override
    public List<RuntimeRule> getRules() {
        return Collections.unmodifiableList(this.ruleStorage.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInner() {
        AbstractRuleSession abstractRuleSession = this;
        synchronized (abstractRuleSession) {
            for (SessionLifecycleListener e : this.lifecycleListeners) {
                e.onEvent(SessionLifecycleListener.Event.PRE_CLOSE);
            }
            this.invalidateSession();
            this.knowledge.close(this);
        }
    }

    private void invalidateSession() {
        this.active = false;
        this.memory.destroy();
    }

    @Override
    public void onNewActiveField(ActiveField newField) {
        this.memory.onNewActiveField(newField);
    }

    @Override
    public final void onNewAlphaBucket(MemoryAddress address) {
        this.memory.onNewAlphaBucket(address);
    }

    void clearInner() {
        for (RuntimeRuleImpl rule : this.ruleStorage) {
            rule.clear();
        }
        this.memory.clear();
        this.actionBuffer.clear();
    }

    abstract void bufferUpdate(FactHandle var1, FactRecord var2, Object var3);

    abstract void bufferDelete(FactHandle var1);

    static void bufferUpdate(FactHandle handle, FactRecord previous, Object updatedFact, FactActionBuffer buffer) {
        buffer.newUpdate(handle, previous, updatedFact);
    }

    static void bufferDelete(FactHandle handle, FactRecord previous, FactActionBuffer buffer) {
        buffer.newDelete(handle, previous);
    }

    final FactHandle bufferInsert(Object fact, boolean resolveCollections, FactActionBuffer buffer) {
        this._assertActive();
        Object arg = Objects.requireNonNull(fact, "Null facts are not supported");
        Optional<Collection<?>> collection = AbstractRuleSession.resolveCollection(arg, resolveCollections);
        if (collection.isPresent()) {
            for (Object o : collection.get()) {
                Optional<FactTuple> insertResult = this.insertAtomic(o);
                insertResult.ifPresent(t -> buffer.newInsert(t.handle, t.record));
            }
            return null;
        }
        Optional<FactTuple> insertResult = this.insertAtomic(arg);
        insertResult.ifPresent(t -> buffer.newInsert(t.handle, t.record));
        return insertResult.map(t -> t.handle).orElse(null);
    }

    final FactHandle bufferInsert(Object fact, String namedType, boolean resolveCollections, FactActionBuffer buffer) {
        this._assertActive();
        Object arg = Objects.requireNonNull(fact, "Null facts are not supported");
        Type type = this.getType(namedType);
        if (type == null) {
            if (this.warnUnknownTypes) {
                LOGGER.warning("Can not map type for '" + fact.getClass().getName() + "', insert operation skipped.");
            }
            return null;
        }
        Optional<Collection<?>> collection = AbstractRuleSession.resolveCollection(arg, resolveCollections);
        if (collection.isPresent()) {
            for (Object o : collection.get()) {
                Optional<FactTuple> insertResult = this.insertAtomic(type, o);
                insertResult.ifPresent(t -> buffer.newInsert(t.handle, t.record));
            }
            return null;
        }
        Optional<FactTuple> insertResult = this.insertAtomic(type, arg);
        insertResult.ifPresent(t -> buffer.newInsert(t.handle, t.record));
        return insertResult.map(t -> t.handle).orElse(null);
    }

    private static Optional<Collection<?>> resolveCollection(Object o, boolean resolveCollection) {
        if (!resolveCollection) {
            return Optional.empty();
        }
        if (o.getClass().isArray()) {
            return Optional.of(Arrays.asList((Object[])o));
        }
        if (o instanceof Iterable) {
            LinkedList ret = new LinkedList();
            ((Iterable)o).forEach(ret::add);
            return Optional.of(ret);
        }
        return Optional.empty();
    }

    private Optional<FactTuple> insertAtomic(Object o) {
        Type type = this.resolve(o);
        if (type == null) {
            if (this.warnUnknownTypes) {
                LOGGER.warning("Can not map type for '" + o.getClass().getName() + "', insert operation skipped.");
            }
            return Optional.empty();
        }
        return this.insertAtomic(type, o);
    }

    private Optional<FactTuple> insertAtomic(Type<?> type, Object o) {
        return this.memory.get(type).register(o);
    }
}

