/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.evrete.Configuration;
import org.evrete.KnowledgeService;
import org.evrete.api.ActivationManager;
import org.evrete.api.ActivationMode;
import org.evrete.api.Evaluator;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.ExpressionResolver;
import org.evrete.api.FieldReference;
import org.evrete.api.Imports;
import org.evrete.api.NamedType;
import org.evrete.api.RhsContext;
import org.evrete.api.Rule;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuleScope;
import org.evrete.api.RuleSet;
import org.evrete.api.RuntimeContext;
import org.evrete.api.TypeField;
import org.evrete.api.TypeResolver;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeMetaData;
import org.evrete.runtime.async.ForkJoinExecutor;
import org.evrete.runtime.builder.RuleBuilderImpl;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.DefaultActivationManager;
import org.evrete.util.compiler.CompilationException;

public abstract class AbstractRuntime<R extends Rule, C extends RuntimeContext<C>>
extends RuntimeMetaData<C>
implements RuleSet<R> {
    private static final Logger LOGGER = Logger.getLogger(AbstractRuntime.class.getName());
    private final List<RuleBuilder<C>> ruleBuilders = new ArrayList<RuleBuilder<C>>();
    private final KnowledgeService service;
    private final Configuration configuration;
    private ExpressionResolver expressionResolver;
    private Comparator<Rule> ruleComparator = SALIENCE_COMPARATOR;
    private Class<? extends ActivationManager> activationManagerFactory;
    private ActivationMode agendaMode;

    AbstractRuntime(KnowledgeService service) {
        this(service, service.newTypeResolver());
    }

    AbstractRuntime(KnowledgeService service, TypeResolver typeResolver) {
        super(service, typeResolver);
        this.configuration = service.getConfiguration().copyOf();
        this.service = service;
        this.activationManagerFactory = DefaultActivationManager.class;
        this.agendaMode = ActivationMode.DEFAULT;
    }

    AbstractRuntime(AbstractRuntime<?, ?> parent) {
        super(parent);
        this.configuration = parent.configuration.copyOf();
        this.service = parent.service;
        this.ruleComparator = parent.ruleComparator;
        this.activationManagerFactory = parent.activationManagerFactory;
        this.agendaMode = parent.agendaMode;
        this.expressionResolver = null;
    }

    ActivationMode getAgendaMode() {
        return this.agendaMode;
    }

    @Override
    public C setActivationMode(ActivationMode activationMode) {
        this._assertActive();
        this.agendaMode = activationMode;
        return (C)this;
    }

    @Override
    public KnowledgeService getService() {
        this._assertActive();
        return this.service;
    }

    @Override
    public Class<? extends ActivationManager> getActivationManagerFactory() {
        this._assertActive();
        return this.activationManagerFactory;
    }

    @Override
    public <A extends ActivationManager> void setActivationManagerFactory(Class<A> managerClass) {
        this._assertActive();
        this.activationManagerFactory = managerClass;
    }

    @Override
    public final void setActivationManagerFactory(String managerClass) {
        this._assertActive();
        try {
            Class<?> factory = Class.forName(managerClass, true, this.getClassLoader());
            this.setActivationManagerFactory(factory);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(managerClass);
        }
    }

    ActivationManager newActivationManager() {
        try {
            return this.activationManagerFactory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to create activation manager. Probably the provided factory class has no public and zero-argument constructor.", e);
        }
    }

    @Override
    public Comparator<Rule> getRuleComparator() {
        return this.ruleComparator;
    }

    @Override
    public void setRuleComparator(Comparator<Rule> ruleComparator) {
        this._assertActive();
        this.ruleComparator = ruleComparator;
    }

    ForkJoinExecutor getExecutor() {
        this._assertActive();
        return this.service.getExecutor();
    }

    public Evaluator compile(String expression, NamedType.Resolver resolver) {
        return this.compile(expression, resolver, this.getClassLoader(), this.configuration);
    }

    public Evaluator compile(String expression, NamedType.Resolver resolver, ClassLoader classLoader, Properties properties) {
        return this.compile(expression, resolver, this.getJavaImports(RuleScope.LHS, RuleScope.BOTH), classLoader, properties);
    }

    public Evaluator compile(String expression, NamedType.Resolver resolver, Imports imports) {
        return this.compile(expression, resolver, imports, this.getClassLoader(), (Properties)this.configuration);
    }

    public Evaluator compile(String expression, NamedType.Resolver resolver, Imports imports, ClassLoader classLoader, Properties properties) {
        return this.compile(expression, resolver, imports.get(RuleScope.LHS, RuleScope.BOTH), classLoader, properties);
    }

    private Evaluator compile(String expression, NamedType.Resolver resolver, Set<String> imports, ClassLoader classLoader, Properties properties) {
        this._assertActive();
        try {
            return this.getExpressionResolver().buildExpression(expression, resolver, imports, classLoader, properties);
        }
        catch (CompilationException e) {
            LOGGER.warning("Failed source code:\n" + e.getSource());
            LOGGER.log(Level.SEVERE, "Compilation error", e);
            throw new RuntimeException(e);
        }
    }

    FactType buildFactType(NamedType builder, Set<TypeField> fields, Set<EvaluatorHandle> alphaEvaluators, int inRuleId) {
        this._assertActive();
        MemoryAddress memoryAddress = this.buildMemoryAddress(builder.getType(), fields, alphaEvaluators);
        return new FactType(builder.getName(), memoryAddress, inRuleId);
    }

    @Override
    public RuleBuilder<C> newRule() {
        return this.newRule(null);
    }

    @Override
    public RuleBuilderImpl<C> newRule(String name) {
        this._assertActive();
        RuleBuilderImpl rb = new RuleBuilderImpl(this, name);
        this.ruleBuilders.add(rb);
        return rb;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    synchronized RuleDescriptor compileRuleBuilder(RuleBuilder<?> ruleBuilder) {
        this._assertActive();
        if (!this.ruleBuilders.remove(ruleBuilder)) {
            throw new IllegalArgumentException("No such rule builder");
        }
        int currentRuleCount = this.getRules().size();
        String ruleName = ruleBuilder.getName();
        int salience = ruleBuilder.getSalience();
        if (salience == Integer.MIN_VALUE) {
            salience = -1 * (currentRuleCount + 1);
        }
        if (ruleName == null) {
            ruleName = "Rule#" + currentRuleCount;
        }
        if (this.ruleExists(ruleBuilder.getName())) {
            throw new IllegalArgumentException("Rule '" + ruleBuilder.getName() + "' already exists");
        }
        RuleBuilderImpl rb = (RuleBuilderImpl)ruleBuilder;
        return RuleDescriptor.factory(this, rb, ruleName, salience);
    }

    Consumer<RhsContext> compile(String literalRhs, Collection<NamedType> namedTypes, Imports imports, RuleScope ... scopes) {
        this._assertActive();
        try {
            return this.service.getLiteralRhsCompiler().compileRhs(this, literalRhs, namedTypes, imports.get(scopes));
        }
        catch (CompilationException e) {
            Logger.getAnonymousLogger().warning("Failed source\n: " + e.getSource());
            throw new IllegalStateException(e);
        }
    }

    private FieldReference resolveFieldReference(String arg, NamedType.Resolver typeMapper) {
        this._assertActive();
        return this.getExpressionResolver().resolve(arg, typeMapper);
    }

    @Override
    public FieldReference[] resolveFieldReferences(String[] arg, NamedType.Resolver typeMapper) {
        this._assertActive();
        FieldReference[] refs = new FieldReference[arg.length];
        for (int i = 0; i < arg.length; ++i) {
            refs[i] = this.resolveFieldReference(arg[i], typeMapper);
        }
        return refs;
    }

    @Override
    public final synchronized ExpressionResolver getExpressionResolver() {
        this._assertActive();
        if (this.expressionResolver == null) {
            this.expressionResolver = this.service.getExpressionResolverProvider().instance(this);
        }
        return this.expressionResolver;
    }

    abstract void _assertActive();
}

