/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.logging.Logger;
import org.evrete.api.Action;
import org.evrete.api.FactHandle;
import org.evrete.runtime.FactRecordDelta;

public class AtomicMemoryAction {
    private static final Logger LOGGER = Logger.getLogger(AtomicMemoryAction.class.getName());
    public final FactHandle handle;
    public Action action;
    private FactRecordDelta delta;

    AtomicMemoryAction(Action action, FactHandle handle, FactRecordDelta delta) {
        this.action = action;
        this.handle = handle;
        this.delta = delta;
    }

    public FactRecordDelta getDelta() {
        return this.delta;
    }

    void rebuild(Action newAction, FactRecordDelta newDelta) {
        FactRecordDelta updatedDelta;
        block0 : switch (newAction) {
            case INSERT: {
                throw new IllegalStateException("Duplicate insert with the same fact handle");
            }
            case UPDATE: {
                switch (this.action) {
                    case RETRACT: {
                        LOGGER.warning("An attempt was made to update a fact that has been just deleted, update operation skipped");
                        return;
                    }
                    case INSERT: 
                    case UPDATE: {
                        updatedDelta = newDelta;
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case RETRACT: {
                switch (this.action) {
                    case RETRACT: {
                        return;
                    }
                    case INSERT: 
                    case UPDATE: {
                        updatedDelta = FactRecordDelta.deleteDelta(this.delta.getLatest());
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.action = newAction;
        this.delta = updatedDelta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomicMemoryAction that = (AtomicMemoryAction)o;
        return this.handle.equals(that.handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return "{action=" + (Object)((Object)this.action) + ", handle=" + this.handle + ", rec=" + this.delta + '}';
    }
}

