/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import org.evrete.api.Evaluator;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.FactBuilder;
import org.evrete.api.FieldReference;
import org.evrete.api.LhsBuilder;
import org.evrete.api.NamedType;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.api.TypeResolver;
import org.evrete.api.ValuesPredicate;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.builder.RuleBuilderImpl;
import org.evrete.runtime.evaluation.EvaluatorOfArray;
import org.evrete.runtime.evaluation.EvaluatorOfPredicate;
import org.evrete.util.MapOfSet;

public abstract class AbstractLhsBuilder<C extends RuntimeContext<C>, G extends AbstractLhsBuilder<C, ?>>
implements LhsBuilder<C> {
    private static final Set<EvaluatorHandle> EMPTY_ALPHA_CONDITIONS = new HashSet<EvaluatorHandle>();
    private static final Set<TypeField> EMPTY_TYPE_FIELDS = new HashSet<TypeField>();
    private final RuleBuilderImpl<C> ruleBuilder;
    private final Map<String, NamedTypeImpl> declaredLhsTypes;
    private final Set<EvaluatorHandle> betaConditions = new HashSet<EvaluatorHandle>();
    private final MapOfSet<String, EvaluatorHandle> alphaConditions = new MapOfSet();
    private final MapOfSet<String, TypeField> betaFields = new MapOfSet();
    private final AbstractRuntime<?, ?> runtime;

    AbstractLhsBuilder(RuleBuilderImpl<C> ruleBuilder) {
        this.ruleBuilder = ruleBuilder;
        this.declaredLhsTypes = new HashMap<String, NamedTypeImpl>();
        this.runtime = ruleBuilder.getRuntimeContext();
    }

    protected abstract G self();

    public Set<EvaluatorHandle> getAlphaConditions(NamedType type) {
        return this.alphaConditions.getOrDefault(type.getName(), (EvaluatorHandle)((Object)EMPTY_ALPHA_CONDITIONS));
    }

    public Set<TypeField> getBetaFields(NamedType type) {
        return this.betaFields.getOrDefault(type.getName(), (TypeField)((Object)EMPTY_TYPE_FIELDS));
    }

    public Set<EvaluatorHandle> getBetaConditions() {
        return this.betaConditions;
    }

    @Override
    public NamedType resolve(String var) {
        return this.declaredLhsTypes.get(var);
    }

    private TypeResolver getTypeResolver() {
        return this.ruleBuilder.getRuntimeContext().getTypeResolver();
    }

    private EvaluatorHandle add(EvaluatorHandle handle) {
        Set<NamedType> involvedTypes = handle.namedTypes();
        if (involvedTypes.size() == 1) {
            this.alphaConditions.add(involvedTypes.iterator().next().getName(), handle);
        } else {
            this.betaConditions.add(handle);
            for (FieldReference ref : handle.descriptor()) {
                this.betaFields.add(ref.type().getName(), ref.field());
            }
        }
        return handle;
    }

    public Set<NamedType> getDeclaredFactTypes() {
        return new HashSet<NamedType>(this.declaredLhsTypes.values());
    }

    @Override
    public RuleBuilderImpl<C> getRuleBuilder() {
        return this.ruleBuilder;
    }

    public G where(String ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this.self();
        }
        for (String expression : expressions) {
            this.whereInner(expression);
        }
        return this.self();
    }

    public G where(EvaluatorHandle ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this.self();
        }
        for (EvaluatorHandle expression : expressions) {
            this.add(expression);
        }
        return this.self();
    }

    public G where(String expression, double complexity) {
        this.whereInner(expression, complexity);
        return this.self();
    }

    public G where(Predicate<Object[]> predicate, double complexity, String ... references) {
        this.whereInner(predicate, complexity, references);
        return this.self();
    }

    public G where(Predicate<Object[]> predicate, String ... references) {
        this.whereInner(predicate, references);
        return this.self();
    }

    public G where(ValuesPredicate predicate, double complexity, String ... references) {
        this.whereInner(predicate, complexity, references);
        return this.self();
    }

    public G where(ValuesPredicate predicate, String ... references) {
        this.whereInner(predicate, references);
        return this.self();
    }

    public G where(Predicate<Object[]> predicate, double complexity, FieldReference ... references) {
        this.whereInner(predicate, complexity, references);
        return this.self();
    }

    public G where(Predicate<Object[]> predicate, FieldReference ... references) {
        this.whereInner(predicate, references);
        return this.self();
    }

    public G where(ValuesPredicate predicate, double complexity, FieldReference ... references) {
        this.whereInner(predicate, complexity, references);
        return this.self();
    }

    public G where(ValuesPredicate predicate, FieldReference ... references) {
        this.whereInner(predicate, references);
        return this.self();
    }

    @Override
    public EvaluatorHandle addWhere(String expression, double complexity, ClassLoader classLoader, Properties properties) {
        Evaluator evaluator = this.runtime.compile(expression, (NamedType.Resolver)this, this.ruleBuilder.getImports(), classLoader, properties);
        return this.add(this.runtime.addEvaluator(evaluator));
    }

    @Override
    public EvaluatorHandle addWhere(ValuesPredicate predicate, double complexity, String ... references) {
        return this.addWhere(predicate, complexity, this.resolveFieldReferences(references));
    }

    @Override
    public EvaluatorHandle addWhere(Predicate<Object[]> predicate, double complexity, String ... references) {
        return this.addWhere(predicate, complexity, this.resolveFieldReferences(references));
    }

    @Override
    public EvaluatorHandle addWhere(ValuesPredicate predicate, double complexity, FieldReference ... references) {
        EvaluatorOfPredicate evaluator = new EvaluatorOfPredicate(predicate, references);
        return this.add(this.runtime.addEvaluator(evaluator));
    }

    @Override
    public EvaluatorHandle addWhere(Predicate<Object[]> predicate, double complexity, FieldReference ... references) {
        EvaluatorOfArray evaluator = new EvaluatorOfArray(predicate, references);
        return this.add(this.runtime.addEvaluator(evaluator));
    }

    private void whereInner(String expression, double complexity) {
        Evaluator evaluator = this.runtime.compile(expression, this, this.ruleBuilder.getImports());
        this.add(this.runtime.addEvaluator(evaluator, complexity));
    }

    private void whereInner(Predicate<Object[]> predicate, double complexity, String[] references) {
        FieldReference[] descriptor = this.resolveFieldReferences(references);
        EvaluatorOfArray evaluator = new EvaluatorOfArray(predicate, descriptor);
        this.add(this.runtime.addEvaluator(evaluator, complexity));
    }

    private void whereInner(Predicate<Object[]> predicate, String[] references) {
        this.whereInner(predicate, 1.0, references);
    }

    private void whereInner(ValuesPredicate predicate, double complexity, String[] references) {
        FieldReference[] descriptor = this.resolveFieldReferences(references);
        EvaluatorOfPredicate evaluator = new EvaluatorOfPredicate(predicate, descriptor);
        this.add(this.runtime.addEvaluator(evaluator, complexity));
    }

    private void whereInner(ValuesPredicate predicate, String[] references) {
        this.whereInner(predicate, 1.0, references);
    }

    private void whereInner(Predicate<Object[]> predicate, double complexity, FieldReference[] references) {
        EvaluatorOfArray evaluator = new EvaluatorOfArray(predicate, references);
        this.add(this.runtime.addEvaluator(evaluator, complexity));
    }

    private void whereInner(Predicate<Object[]> predicate, FieldReference[] references) {
        this.whereInner(predicate, 1.0, references);
    }

    private void whereInner(ValuesPredicate predicate, double complexity, FieldReference[] references) {
        EvaluatorOfPredicate evaluator = new EvaluatorOfPredicate(predicate, references);
        this.add(this.runtime.addEvaluator(evaluator, complexity));
    }

    private void whereInner(ValuesPredicate predicate, FieldReference[] references) {
        this.whereInner(predicate, 1.0, references);
    }

    private void whereInner(String expression) {
        this.whereInner(expression, 1.0);
    }

    private FieldReference[] resolveFieldReferences(String[] references) {
        return this.runtime.resolveFieldReferences(references, this);
    }

    @Override
    public synchronized NamedTypeImpl addFactDeclaration(String name, Type<?> type) {
        this.checkRefName(name);
        NamedTypeImpl factType = new NamedTypeImpl(name, type);
        this.declaredLhsTypes.put(name, factType);
        return factType;
    }

    @Override
    public NamedType addFactDeclaration(String name, String type) {
        return this.addFactDeclaration(name, this.getTypeResolver().getOrDeclare(type));
    }

    G buildLhs(Collection<FactBuilder> facts) {
        if (facts == null || facts.isEmpty()) {
            return this.self();
        }
        for (FactBuilder f : facts) {
            Class<?> c = f.getResolvedType();
            if (c == null) {
                this.addFactDeclaration(f.getName(), f.getUnresolvedType());
                continue;
            }
            this.addFactDeclaration(f.getName(), c);
        }
        return this.self();
    }

    @Override
    public NamedType addFactDeclaration(String name, Class<?> type) {
        Type<?> t = this.getTypeResolver().getOrDeclare(type);
        return this.addFactDeclaration(name, (Type)t);
    }

    private void checkRefName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Null or empty type reference in " + this.ruleBuilder);
        }
        if (this.declaredLhsTypes.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate type reference '" + name + "' in rule " + this.ruleBuilder);
        }
    }

    static class NamedTypeImpl
    implements NamedType {
        private final String name;
        private final Type<?> type;

        NamedTypeImpl(String name, Type<?> type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public Type<?> getType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

