/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.evrete.api.Evaluator;
import org.evrete.api.FieldReference;
import org.evrete.api.IntToValue;
import org.evrete.spi.minimal.ConditionStringTerm;
import org.evrete.spi.minimal.JcCompiler;
import org.evrete.util.NextIntSupplier;
import org.evrete.util.StringLiteralRemover;
import org.evrete.util.compiler.CompilationException;

class EvaluatorCompiler {
    private static final String JAVA_EVALUATOR_TEMPLATE = "package %s;\n%s\n\npublic final class %s extends %s {\n    public static final java.lang.invoke.MethodHandle HANDLE;\n\n    static {\n        try {\n            HANDLE = java.lang.invoke.MethodHandles.lookup().findStatic(%s.class, \"__$test\", java.lang.invoke.MethodType.methodType(boolean.class, %s));\n        } catch (Exception e) {\n            throw new IllegalStateException(e);\n        }\n    }\n\n    private static boolean __$testInner(%s) {\n        return %s;\n    }\n\n    public static boolean __$test(%s) {\n        return %s\n    }\n\n    //IMPORTANT LINE BELOW, IT IS USED IN SOURCE/SIGNATURE COMPARISON\n    //%s\n}\n";
    private static final NextIntSupplier javaClassCounter = new NextIntSupplier();
    private final JcCompiler compiler;

    EvaluatorCompiler(JcCompiler compiler) {
        this.compiler = compiler;
    }

    private MethodHandle compileExpression(ClassLoader classLoader, String classJavaSource) throws CompilationException {
        try {
            Class<?> compiledClass = this.compiler.compile(classLoader, classJavaSource);
            return (MethodHandle)compiledClass.getDeclaredField("HANDLE").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new CompilationException(e, classJavaSource);
        }
    }

    Evaluator buildExpression(ClassLoader classLoader, String baseClassName, StringLiteralRemover remover, String strippedExpression, List<ConditionStringTerm> terms, Set<String> imports) throws CompilationException {
        int accumulatedShift = 0;
        StringJoiner argClasses = new StringJoiner(", ");
        StringJoiner argTypes = new StringJoiner(", ");
        StringJoiner argCasts = new StringJoiner(", ");
        int castVarIndex = 0;
        StringJoiner methodArgs = new StringJoiner(", ");
        ArrayList<ConditionStringTerm> uniqueReferences = new ArrayList<ConditionStringTerm>();
        ArrayList<ConditionStringTerm> descriptorBuilder = new ArrayList<ConditionStringTerm>();
        for (ConditionStringTerm conditionStringTerm : terms) {
            String original = strippedExpression.substring(conditionStringTerm.start + accumulatedShift, conditionStringTerm.end + accumulatedShift);
            String javaArgVar = conditionStringTerm.varName;
            String before = strippedExpression.substring(0, conditionStringTerm.start + accumulatedShift);
            String after = strippedExpression.substring(conditionStringTerm.end + accumulatedShift);
            strippedExpression = before + javaArgVar + after;
            accumulatedShift += javaArgVar.length() - original.length();
            if (uniqueReferences.contains(conditionStringTerm)) continue;
            descriptorBuilder.add(conditionStringTerm);
            Class<?> fieldType = conditionStringTerm.field().getValueType();
            argTypes.add(conditionStringTerm.type().getType().getName() + "/" + conditionStringTerm.field().getName());
            argCasts.add("(" + fieldType.getCanonicalName() + ") values.apply(" + castVarIndex + ")");
            argClasses.add(fieldType.getName() + ".class");
            methodArgs.add(fieldType.getCanonicalName() + " " + javaArgVar);
            ++castVarIndex;
            uniqueReferences.add(conditionStringTerm);
        }
        StringBuilder importsBuilder = new StringBuilder(1024);
        if (!imports.isEmpty()) {
            for (String imp : imports) {
                importsBuilder.append("import ").append(imp).append(";\n");
            }
            importsBuilder.append("\n");
        }
        String string = remover.unwrapLiterals(strippedExpression);
        String pkg = this.getClass().getPackage().getName() + ".compiled";
        String clazz = "Condition" + javaClassCounter.next();
        String classJavaSource = String.format(JAVA_EVALUATOR_TEMPLATE, pkg, importsBuilder, clazz, baseClassName, clazz, IntToValue.class.getName() + ".class", methodArgs, string, IntToValue.class.getName() + " values", "__$testInner(" + argCasts + ");", "fields in use: " + argTypes);
        String comparableClassSource = classJavaSource.replaceAll(clazz, "CLASS_STUB");
        FieldReference[] descriptor = descriptorBuilder.toArray(FieldReference.ZERO_ARRAY);
        if (descriptor.length == 0) {
            throw new IllegalArgumentException("No field references were resolved in the '" + strippedExpression + "'");
        }
        MethodHandle methodHandle = this.compileExpression(classLoader, classJavaSource);
        return new CompiledEvaluator(methodHandle, remover.getOriginal(), comparableClassSource, descriptor);
    }

    private static class CompiledEvaluator
    implements Evaluator {
        private final FieldReference[] descriptor;
        private final MethodHandle methodHandle;
        private final String original;
        private final String comparableClassSource;

        CompiledEvaluator(MethodHandle methodHandle, String original, String comparableClassSource, FieldReference[] descriptor) {
            this.descriptor = descriptor;
            this.original = original;
            this.comparableClassSource = comparableClassSource;
            this.methodHandle = methodHandle;
        }

        @Override
        public int compare(Evaluator other) {
            if (other instanceof CompiledEvaluator) {
                CompiledEvaluator o = (CompiledEvaluator)other;
                if (o.descriptor.length == 1 && this.descriptor.length == 1 && o.comparableClassSource.equals(this.comparableClassSource)) {
                    return 1;
                }
            }
            return Evaluator.super.compare(other);
        }

        @Override
        public FieldReference[] descriptor() {
            return this.descriptor;
        }

        @Override
        public boolean test(IntToValue values) {
            try {
                return this.methodHandle.invoke(values);
            }
            catch (SecurityException t) {
                throw t;
            }
            catch (Throwable t) {
                Object[] args = new Object[this.descriptor.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = values.apply(i);
                }
                throw new IllegalStateException("Evaluation exception at '" + this.original + "', arguments: " + Arrays.toString(this.descriptor) + " -> " + Arrays.toString(args), t);
            }
        }

        public String toString() {
            return "\"" + this.original + "\"";
        }
    }
}

