/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.tools.JavaFileObject;
import org.evrete.util.IOUtils;
import org.evrete.util.compiler.ClassPathClass;
import org.evrete.util.compiler.CompiledClass;
import org.evrete.util.compiler.ServiceClassLoader;

class PackageExplorer {
    private static final String CLASS_FILE_EXTENSION = ".class";
    private static final String CLASS_MODULE_INFO = "module-info.class";
    private final ServiceClassLoader classLoader;
    private static final Logger LOGGER = Logger.getLogger(PackageExplorer.class.getName());
    private final Map<String, Collection<JavaFileObject>> cache = new HashMap<String, Collection<JavaFileObject>>();

    PackageExplorer(ServiceClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private Collection<JavaFileObject> listUnder(String packageName, URL packageFolderURL) {
        String key = packageName + packageFolderURL;
        Collection<JavaFileObject> cached = this.cache.get(key);
        if (cached == null) {
            cached = this.listUnderUncached(packageName, packageFolderURL);
            this.cache.put(key, cached);
        }
        return cached;
    }

    private Collection<JavaFileObject> listUnderUncached(String packageName, URL packageFolderURL) {
        URLConnection connection;
        Collection<JavaFileObject> result = null;
        try {
            connection = packageFolderURL.openConnection();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (connection instanceof JarURLConnection) {
            result = this.asUrlConnection((JarURLConnection)connection);
        }
        if (result == null) {
            result = this.asFileResource(packageName, packageFolderURL);
        }
        if (result == null) {
            try (InputStream stream = connection.getInputStream();){
                if (stream instanceof ZipInputStream) {
                    ZipInputStream zis = (ZipInputStream)stream;
                    result = this.asZipInputStream(packageName, packageFolderURL, zis);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (result == null) {
            throw new IllegalStateException("Unknown resource type: " + packageFolderURL);
        }
        return result;
    }

    private Collection<JavaFileObject> asFileResource(String packageName, URL packageFolderURL) {
        Collection collection;
        block8: {
            Stream<Path> stream = Files.walk(PackageExplorer.uriToPath(packageFolderURL.toURI()), 1, new FileVisitOption[0]);
            try {
                collection = stream.filter(path -> path.getFileName().toString().endsWith(CLASS_FILE_EXTENSION)).map(path -> {
                    String fileName = path.getFileName().toString();
                    fileName = fileName.substring(0, fileName.length() - CLASS_FILE_EXTENSION.length());
                    String binaryName = packageName + '.' + fileName;
                    return new ClassPathClass(binaryName, path.toUri());
                }).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException | FileSystemNotFoundException ignored) {
                    LOGGER.fine("Not a filesystem resource: " + packageFolderURL);
                    return null;
                }
            }
            stream.close();
        }
        return collection;
    }

    private Collection<JavaFileObject> asUrlConnection(JarURLConnection jarConn) {
        try {
            String rootEntryName = jarConn.getEntryName();
            JarFile jarFile = jarConn.getJarFile();
            return jarFile.stream().filter(e -> {
                String entryName = e.getName();
                return !e.isDirectory() && entryName.startsWith(rootEntryName) && entryName.endsWith(CLASS_FILE_EXTENSION) && !entryName.endsWith(CLASS_MODULE_INFO) && entryName.indexOf(47, rootEntryName.length() + 1) == -1;
            }).map(entry -> {
                String name = entry.getName();
                String fileName = name.replaceAll("/", ".");
                fileName = fileName.substring(0, fileName.length() - CLASS_FILE_EXTENSION.length());
                byte[] bytes = IOUtils.bytes(jarFile, entry);
                try {
                    return new CompiledClass(Class.forName(fileName, false, this.classLoader), bytes);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private Collection<JavaFileObject> asZipInputStream(String packageName, URL packageFolderURL, ZipInputStream zis) {
        System.out.println("P: " + packageName + "\t" + packageFolderURL);
        LinkedList<JavaFileObject> result = new LinkedList<JavaFileObject>();
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String entryName;
                if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(CLASS_FILE_EXTENSION) || entryName.indexOf(47) >= 0 || entryName.endsWith(CLASS_MODULE_INFO)) continue;
                String classEntry = entryName.substring(0, entryName.length() - CLASS_FILE_EXTENSION.length());
                String className = packageName + "." + classEntry;
                byte[] bytes = IOUtils.toByteArray(zis);
                CompiledClass compiledClass = new CompiledClass(Class.forName(className, false, this.classLoader), bytes);
                result.add(compiledClass);
            }
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Path uriToPath(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("Missing scheme");
        }
        if (scheme.equalsIgnoreCase("file")) {
            return FileSystems.getDefault().provider().getPath(uri);
        }
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (!provider.getScheme().equalsIgnoreCase(scheme)) continue;
            return provider.getPath(uri);
        }
        throw new FileSystemNotFoundException("Provider \"" + scheme + "\" not installed");
    }

    List<JavaFileObject> find(String packageName) throws IOException {
        String javaPackageName = packageName.replaceAll("\\.", "/");
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        Enumeration<URL> urlEnumeration = this.classLoader.getResources(javaPackageName);
        while (urlEnumeration.hasMoreElements()) {
            URL packageFolderURL = urlEnumeration.nextElement();
            result.addAll(this.listUnder(packageName, packageFolderURL));
        }
        return result;
    }
}

