/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.evrete.api.Copyable;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.FieldReference;
import org.evrete.api.TypeField;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.Evaluators;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.MetaChangeListener;
import org.evrete.runtime.evaluation.AlphaEvaluator;
import org.evrete.runtime.evaluation.MemoryAddress;

class TypeMemoryMetaData {
    private final int type;
    private final Evaluators evaluators;
    private final MetaChangeListener listener;
    private final ArrayOf<FieldKeyMeta> keyMetas;
    private final AtomicInteger bucketCounter;
    private final AtomicInteger bucketIds;
    ActiveField[] activeFields;
    AlphaEvaluator[] alphaEvaluators;

    TypeMemoryMetaData(int type, Evaluators evaluators, AtomicInteger bucketIds, MetaChangeListener listener) {
        this.type = type;
        this.activeFields = ActiveField.ZERO_ARRAY;
        this.alphaEvaluators = new AlphaEvaluator[0];
        this.evaluators = evaluators;
        this.listener = listener;
        this.keyMetas = new ArrayOf<FieldKeyMeta>(FieldKeyMeta.class);
        this.bucketCounter = new AtomicInteger(0);
        this.bucketIds = bucketIds;
    }

    private TypeMemoryMetaData(TypeMemoryMetaData other, Evaluators evaluators, AtomicInteger bucketIds, MetaChangeListener listener) {
        this.activeFields = Arrays.copyOf(other.activeFields, other.activeFields.length);
        this.alphaEvaluators = Arrays.copyOf(other.alphaEvaluators, other.alphaEvaluators.length);
        this.type = other.type;
        this.evaluators = evaluators;
        this.listener = listener;
        this.keyMetas = new ArrayOf<FieldKeyMeta>(FieldKeyMeta.class);
        this.bucketCounter = new AtomicInteger(other.bucketCounter.get());
        this.bucketIds = bucketIds;
        other.keyMetas.forEach((meta, i) -> this.keyMetas.set(i, meta.copyOf()));
    }

    private synchronized AlphaEvaluator append(EvaluatorHandle wrapper, ActiveField[] descriptor) {
        int newId = this.alphaEvaluators.length;
        AlphaEvaluator alphaEvaluator = new AlphaEvaluator(newId, wrapper, descriptor);
        this.alphaEvaluators = Arrays.copyOf(this.alphaEvaluators, this.alphaEvaluators.length + 1);
        this.alphaEvaluators[newId] = alphaEvaluator;
        return alphaEvaluator;
    }

    TypeMemoryMetaData copyOf(Evaluators evaluators, AtomicInteger bucketIds, MetaChangeListener listener) {
        return new TypeMemoryMetaData(this, evaluators, bucketIds, listener);
    }

    synchronized TypeMemoryMeta buildAlphaMask(FieldsKey key, Set<EvaluatorHandle> alphaEvaluators) {
        AlphaEvaluator[] existing = this.alphaEvaluators;
        HashSet<MatchedAlphaEvaluator> matches = new HashSet<MatchedAlphaEvaluator>();
        for (EvaluatorHandle evaluatorHandle : alphaEvaluators) {
            MatchedAlphaEvaluator match = MatchedAlphaEvaluator.search(this.evaluators, existing, evaluatorHandle);
            if (match == null) {
                AlphaEvaluator alphaEvaluator = this.append(evaluatorHandle, this.convertDescriptor(evaluatorHandle.descriptor()));
                existing = this.alphaEvaluators;
                matches.add(new MatchedAlphaEvaluator(alphaEvaluator, true));
                continue;
            }
            matches.add(match);
        }
        FieldKeyMeta fieldKeyMeta = this.getKeyMeta(key);
        for (TypeMemoryMeta meta : fieldKeyMeta.alphaBuckets) {
            if (!meta.sameKey(matches)) continue;
            return meta;
        }
        TypeMemoryMeta typeMemoryMeta = fieldKeyMeta.newMeta(matches, this.bucketIds, this.bucketCounter);
        this.listener.onNewAlphaBucket(typeMemoryMeta);
        return typeMemoryMeta;
    }

    private ActiveField[] convertDescriptor(FieldReference[] descriptor) {
        ActiveField[] converted = new ActiveField[descriptor.length];
        for (int i = 0; i < descriptor.length; ++i) {
            ActiveField activeField;
            TypeField field = descriptor[i].field();
            converted[i] = activeField = this.getCreate(field);
        }
        return converted;
    }

    synchronized ActiveField getCreate(TypeField field) {
        for (ActiveField af : this.activeFields) {
            if (af.field() != field.getId()) continue;
            return af;
        }
        int id = this.activeFields.length;
        ActiveField af = new ActiveField(field, id);
        this.activeFields = Arrays.copyOf(this.activeFields, id + 1);
        this.activeFields[id] = af;
        this.listener.onNewActiveField(af);
        return af;
    }

    private FieldKeyMeta getKeyMeta(FieldsKey key) {
        return this.keyMetas.computeIfAbsent(key.getId(), k -> new FieldKeyMeta(key));
    }

    private static class FieldKeyMeta
    implements Copyable<FieldKeyMeta> {
        private final FieldsKey fields;
        private TypeMemoryMeta[] alphaBuckets;

        FieldKeyMeta(FieldsKey fields) {
            this.fields = fields;
            this.alphaBuckets = new TypeMemoryMeta[0];
        }

        FieldKeyMeta(FieldKeyMeta other) {
            this.fields = other.fields;
            this.alphaBuckets = Arrays.copyOf(other.alphaBuckets, other.alphaBuckets.length);
        }

        synchronized TypeMemoryMeta newMeta(Set<MatchedAlphaEvaluator> matches, AtomicInteger bucketIds, AtomicInteger bucketCounter) {
            int idx = this.alphaBuckets.length;
            int bucketIndex = bucketCounter.getAndIncrement();
            int id = bucketIds.getAndIncrement();
            TypeMemoryMeta newMeta = TypeMemoryMeta.factory(id, bucketIndex, this.fields, matches);
            this.alphaBuckets = Arrays.copyOf(this.alphaBuckets, this.alphaBuckets.length + 1);
            this.alphaBuckets[idx] = newMeta;
            return newMeta;
        }

        @Override
        public FieldKeyMeta copyOf() {
            return new FieldKeyMeta(this);
        }
    }

    static class MatchedAlphaEvaluator {
        final AlphaEvaluator matched;
        final boolean direct;

        MatchedAlphaEvaluator(AlphaEvaluator matched, boolean direct) {
            this.matched = matched;
            this.direct = direct;
        }

        static MatchedAlphaEvaluator search(Evaluators evaluators, AlphaEvaluator[] scope, EvaluatorHandle subject) {
            block5: for (AlphaEvaluator evaluator : scope) {
                int cmp = evaluators.compare(evaluator.getDelegate(), subject);
                switch (cmp) {
                    case 1: {
                        return new MatchedAlphaEvaluator(evaluator, true);
                    }
                    case -1: {
                        return new MatchedAlphaEvaluator(evaluator, false);
                    }
                    case 0: {
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatchedAlphaEvaluator match = (MatchedAlphaEvaluator)o;
            return this.direct == match.direct && this.matched.equals(match.matched);
        }

        public int hashCode() {
            return this.matched.hashCode() + 37 * Boolean.hashCode(this.direct);
        }
    }

    public static abstract class TypeMemoryMeta
    implements MemoryAddress {
        private static final Set<MatchedAlphaEvaluator> EMPTY_COMPONENTS = new HashSet<MatchedAlphaEvaluator>();
        private final int bucketIndex;
        private final int id;
        private final FieldsKey typeFields;
        private final Set<MatchedAlphaEvaluator> key;

        private TypeMemoryMeta(int id, int bucketIndex, FieldsKey fields, Set<MatchedAlphaEvaluator> matches) {
            this.id = id;
            this.key = matches;
            this.typeFields = fields;
            this.bucketIndex = bucketIndex;
        }

        static TypeMemoryMeta factory(int id, int bucketIndex, FieldsKey fields, Set<MatchedAlphaEvaluator> matches) {
            switch (matches.size()) {
                case 0: {
                    return new Empty(id, bucketIndex, fields);
                }
                case 1: {
                    return new Single(id, bucketIndex, fields, matches);
                }
            }
            return new Multi(id, bucketIndex, fields, matches);
        }

        @Override
        public int getBucketIndex() {
            return this.bucketIndex;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public FieldsKey fields() {
            return this.typeFields;
        }

        final boolean sameKey(Set<MatchedAlphaEvaluator> other) {
            if (this.key.isEmpty() && other.isEmpty()) {
                return true;
            }
            return this.key.equals(other);
        }

        @Override
        public final boolean isEmpty() {
            return this.key.isEmpty();
        }

        public static final class Empty
        extends TypeMemoryMeta {
            Empty(int id, int bucketIndex, FieldsKey fields) {
                super(id, bucketIndex, fields, EMPTY_COMPONENTS);
            }

            @Override
            public boolean testAlphaBits(BitSet mask) {
                return true;
            }
        }

        public static final class Single
        extends TypeMemoryMeta {
            private final int bitIndex;
            private final boolean expectedValue;

            Single(int id, int bucketIndex, FieldsKey fields, Set<MatchedAlphaEvaluator> matches) {
                super(id, bucketIndex, fields, matches);
                MatchedAlphaEvaluator match = matches.iterator().next();
                this.expectedValue = match.direct;
                this.bitIndex = match.matched.getIndex();
            }

            @Override
            public boolean testAlphaBits(BitSet mask) {
                return mask.get(this.bitIndex) == this.expectedValue;
            }
        }

        public static final class Multi
        extends TypeMemoryMeta {
            private final int[] bitIndices;
            private final BitSet expectedValues = new BitSet();

            Multi(int id, int bucketIndex, FieldsKey fields, Set<MatchedAlphaEvaluator> matches) {
                super(id, bucketIndex, fields, matches);
                ArrayList<MatchedAlphaEvaluator> sortedMatches = new ArrayList<MatchedAlphaEvaluator>(matches);
                sortedMatches.sort(Comparator.comparingDouble(o -> o.matched.getDelegate().getComplexity()));
                this.bitIndices = new int[sortedMatches.size()];
                int i = 0;
                for (MatchedAlphaEvaluator match : sortedMatches) {
                    this.bitIndices[i] = match.matched.getIndex();
                    if (match.direct) {
                        this.expectedValues.set(match.matched.getIndex());
                    }
                    ++i;
                }
            }

            @Override
            public boolean testAlphaBits(BitSet mask) {
                for (int idx : this.bitIndices) {
                    if (mask.get(idx) == this.expectedValues.get(idx)) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return "{bucket=" + this.getBucketIndex() + ", values=" + this.expectedValues + '}';
            }
        }
    }
}

