/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.api;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.evrete.api.Copyable;
import org.evrete.api.Named;
import org.evrete.api.TypeField;

public interface Type<T>
extends Named,
Copyable<Type<T>> {
    public int getId();

    public Class<T> resolveJavaType();

    public String getJavaType();

    public Collection<TypeField> getDeclaredFields();

    public TypeField getField(String var1);

    @Deprecated
    default public TypeField getField(int id) {
        throw new UnsupportedOperationException();
    }

    public <V> TypeField declareField(String var1, Class<V> var2, Function<T, V> var3);

    default public TypeField declareIntField(String name, ToIntFunction<T> function) {
        return this.declareField(name, Integer.TYPE, function::applyAsInt);
    }

    default public TypeField declareLongField(String name, ToLongFunction<T> function) {
        return this.declareField(name, Long.TYPE, function::applyAsLong);
    }

    default public TypeField declareDoubleField(String name, ToDoubleFunction<T> function) {
        return this.declareField(name, Double.TYPE, function::applyAsDouble);
    }

    default public TypeField declareBooleanField(String name, Predicate<T> function) {
        return this.declareField(name, Boolean.TYPE, function::test);
    }
}

