/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.evrete.api.Evaluator;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.FactBuilder;
import org.evrete.api.FieldReference;
import org.evrete.api.LhsBuilder;
import org.evrete.api.NamedType;
import org.evrete.api.RhsContext;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.ValuesPredicate;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.DefaultNamedTypeResolver;
import org.evrete.runtime.RuleBuilderImpl;
import org.evrete.runtime.evaluation.EvaluatorOfArray;
import org.evrete.runtime.evaluation.EvaluatorOfPredicate;
import org.evrete.util.NamedTypeImpl;

class LhsBuilderImpl<C extends RuntimeContext<C>>
implements LhsBuilder<C> {
    private final RuleBuilderImpl<C> ruleBuilder;
    private final Collection<NamedTypeImpl> declaredLhsTypes;
    private final AbstractRuntime<?, C> runtime;
    private final Collection<Callable<EvaluatorHandle>> conditions = new LinkedList<Callable<EvaluatorHandle>>();
    private NamedTypeResolver typeResolver;

    LhsBuilderImpl(RuleBuilderImpl<C> ruleBuilder) {
        this.ruleBuilder = ruleBuilder;
        this.declaredLhsTypes = new LinkedList<NamedTypeImpl>();
        this.runtime = ruleBuilder.getRuntimeContext();
    }

    @Override
    public synchronized NamedTypeImpl addFactDeclaration(String name, Type<?> type) {
        this.typeResolver = null;
        NamedTypeImpl factType = new NamedTypeImpl(type, name);
        this.declaredLhsTypes.add(factType);
        return factType;
    }

    Set<NamedType> getDeclaredFactTypes() {
        return new HashSet<NamedType>(this.resolver().resolver.values());
    }

    @Override
    public RuleBuilder<C> create() {
        return this.ruleBuilder;
    }

    @Override
    public C execute(Consumer<RhsContext> consumer) {
        return this.ruleBuilder.build(consumer);
    }

    @Override
    public C execute(String literalRhs) {
        return this.ruleBuilder.build(literalRhs);
    }

    @Override
    public NamedType addFactDeclaration(String name, Class<?> type) {
        Type<?> t = this.runtime.getTypeResolver().getOrDeclare(type);
        return this.addFactDeclaration(name, (Type)t);
    }

    @Override
    public NamedType addFactDeclaration(String name, String type) {
        return this.addFactDeclaration(name, this.runtime.getTypeResolver().getOrDeclare(type));
    }

    @Override
    public RuleBuilder<C> setRhs(String literalConsumer) {
        this.ruleBuilder.setRhs(literalConsumer);
        return this.ruleBuilder;
    }

    Collection<EvaluatorHandle> resolveConditions() {
        try {
            ArrayList<EvaluatorHandle> resolved = new ArrayList<EvaluatorHandle>(this.conditions.size());
            for (Callable<EvaluatorHandle> c : this.conditions) {
                resolved.add(c.call());
            }
            return resolved;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public LhsBuilderImpl<C> where(EvaluatorHandle ... expressions) {
        if (expressions == null) {
            return this;
        }
        for (EvaluatorHandle expression : expressions) {
            this.add(() -> expression);
        }
        return this;
    }

    @Override
    public LhsBuilderImpl<C> where(String expression, double complexity) {
        this.whereInner(expression, complexity);
        return this;
    }

    @Override
    public LhsBuilderImpl<C> where(ValuesPredicate predicate, double complexity, String ... references) {
        this.whereInner(predicate, complexity, references);
        return this;
    }

    @Override
    public LhsBuilderImpl<C> where(Predicate<Object[]> predicate, double complexity, FieldReference ... references) {
        this.whereInner(predicate, complexity, references);
        return this;
    }

    @Override
    public LhsBuilderImpl<C> where(Predicate<Object[]> predicate, double complexity, String ... references) {
        this.whereInner(predicate, complexity, references);
        return this;
    }

    @Override
    public NamedType resolve(String var) {
        return this.resolver().resolve(var);
    }

    @Override
    public LhsBuilderImpl<C> where(ValuesPredicate predicate, double complexity, FieldReference ... references) {
        this.whereInner(predicate, complexity, references);
        return this;
    }

    @Override
    public C execute() {
        return this.ruleBuilder.build();
    }

    LhsBuilderImpl<C> buildLhs(Collection<FactBuilder> facts) {
        if (facts == null || facts.isEmpty()) {
            return this;
        }
        for (FactBuilder f : facts) {
            Class<?> c = f.getResolvedType();
            if (c == null) {
                this.addFactDeclaration(f.getName(), f.getUnresolvedType());
                continue;
            }
            this.addFactDeclaration(f.getName(), c);
        }
        return this;
    }

    private void whereInner(String expression, double complexity) {
        this.add(() -> {
            Evaluator evaluator = this.runtime.compile(expression, this);
            return this.runtime.addEvaluator(evaluator, complexity);
        });
    }

    private void whereInner(ValuesPredicate predicate, double complexity, FieldReference[] references) {
        this.add(() -> {
            EvaluatorOfPredicate evaluator = new EvaluatorOfPredicate(predicate, references);
            return this.runtime.addEvaluator(evaluator, complexity);
        });
    }

    private void whereInner(Predicate<Object[]> predicate, double complexity, FieldReference[] references) {
        this.add(() -> {
            EvaluatorOfArray evaluator = new EvaluatorOfArray(predicate, references);
            return this.runtime.addEvaluator(evaluator, complexity);
        });
    }

    private void whereInner(ValuesPredicate predicate, double complexity, String[] references) {
        this.add(() -> {
            FieldReference[] descriptor = this.resolveFieldReferences(references);
            EvaluatorOfPredicate evaluator = new EvaluatorOfPredicate(predicate, descriptor);
            return this.runtime.addEvaluator(evaluator, complexity);
        });
    }

    private void whereInner(Predicate<Object[]> predicate, double complexity, String[] references) {
        this.add(() -> {
            FieldReference[] descriptor = this.resolveFieldReferences(references);
            EvaluatorOfArray evaluator = new EvaluatorOfArray(predicate, descriptor);
            return this.runtime.addEvaluator(evaluator, complexity);
        });
    }

    private FieldReference[] resolveFieldReferences(String[] references) {
        return this.runtime.resolveFieldReferences(references, this);
    }

    private void add(Callable<EvaluatorHandle> handle) {
        this.conditions.add(handle);
    }

    private synchronized NamedTypeResolver resolver() {
        if (this.typeResolver == null) {
            this.typeResolver = new NamedTypeResolver();
        }
        return this.typeResolver;
    }

    private class NamedTypeResolver
    implements NamedType.Resolver {
        private final DefaultNamedTypeResolver<NamedTypeImpl> resolver = new DefaultNamedTypeResolver();

        NamedTypeResolver() {
            for (NamedTypeImpl t : LhsBuilderImpl.this.declaredLhsTypes) {
                this.resolver.put(t.getName(), t);
            }
        }

        @Override
        public NamedType resolve(String var) {
            return this.resolver.resolve(var);
        }
    }
}

