/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.evrete.api.Evaluator;
import org.evrete.api.ExpressionResolver;
import org.evrete.api.FieldReference;
import org.evrete.api.Imports;
import org.evrete.api.NamedType;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.spi.minimal.BaseConditionClass;
import org.evrete.spi.minimal.ConditionStringTerm;
import org.evrete.spi.minimal.Const;
import org.evrete.spi.minimal.EvaluatorCompiler;
import org.evrete.spi.minimal.FieldReferenceImpl;
import org.evrete.spi.minimal.JcCompiler;
import org.evrete.util.NextIntSupplier;
import org.evrete.util.StringLiteralRemover;
import org.evrete.util.compiler.CompilationException;

class DefaultExpressionResolver
implements ExpressionResolver {
    private static final String BASE_CLASS_PROPERTY = "evrete.impl.condition-base-class";
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("\\$[a-zA-Z0-9]+(\\.[_a-zA-Z][_a-zA-Z0-9]*)*");
    private final EvaluatorCompiler evaluatorCompiler;
    private final RuntimeContext<?> context;

    DefaultExpressionResolver(RuntimeContext<?> requester, JcCompiler compiler) {
        this.evaluatorCompiler = new EvaluatorCompiler(compiler);
        this.context = requester;
    }

    private static ConditionStringTerm resolveTerm(int start, int actualEnd, FieldReference ref, NextIntSupplier fieldCounter, List<ConditionStringTerm> terms) {
        for (ConditionStringTerm t : terms) {
            if (!t.type().equals(ref.type()) || !t.field().equals(ref.field())) continue;
            return new ConditionStringTerm(start, actualEnd, t);
        }
        return new ConditionStringTerm(start, actualEnd, ref, fieldCounter);
    }

    @Override
    public FieldReference resolve(String arg, NamedType.Resolver resolver) {
        TypeField field;
        NamedType typeRef;
        int firstDot = arg.indexOf(46);
        if (firstDot < 0) {
            typeRef = resolver.resolve(arg);
            field = typeRef.getType().getField("");
        } else {
            String lhsFactType = arg.substring(0, firstDot);
            String dottedProp = arg.substring(firstDot + 1);
            Const.assertName(dottedProp);
            Const.assertName(lhsFactType.substring(1));
            typeRef = resolver.resolve(lhsFactType);
            Type<?> type = typeRef.getType();
            field = type.getField(dottedProp);
        }
        return new FieldReferenceImpl(typeRef, field);
    }

    @Override
    public synchronized Evaluator buildExpression(String expression, NamedType.Resolver resolver) throws CompilationException {
        try {
            String conditionBaseClass = this.context.getConfiguration().getProperty(BASE_CLASS_PROPERTY);
            if (conditionBaseClass == null) {
                conditionBaseClass = BaseConditionClass.class.getName();
            }
            Imports imports = this.context.getImports();
            try {
                return this.buildExpression(expression, conditionBaseClass, resolver, imports, true);
            }
            catch (Throwable e) {
                return this.buildExpression(expression, conditionBaseClass, resolver, imports, false);
            }
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CompilationException(t, expression);
        }
    }

    private Evaluator buildExpression(String rawExpression, String conditionBaseClassName, NamedType.Resolver resolver, Imports imports, boolean stripWhiteSpaces) throws CompilationException {
        ClassLoader classLoader = this.context.getClassLoader();
        StringLiteralRemover remover = StringLiteralRemover.of(rawExpression, stripWhiteSpaces);
        String strippedExpression = remover.getConverted();
        Matcher m = REFERENCE_PATTERN.matcher(strippedExpression);
        ArrayList<ConditionStringTerm> terms = new ArrayList<ConditionStringTerm>();
        NextIntSupplier fieldCounter = new NextIntSupplier();
        while (m.find()) {
            int end;
            int start = m.start();
            int actualEnd = end = m.end();
            if (end < strippedExpression.length() && strippedExpression.charAt(end) == '(') {
                actualEnd = strippedExpression.substring(start, end).lastIndexOf(46) + start;
            }
            String s = strippedExpression.substring(start, actualEnd);
            FieldReference fieldReference = this.resolve(s, resolver);
            ConditionStringTerm t = DefaultExpressionResolver.resolveTerm(start, actualEnd, fieldReference, fieldCounter, terms);
            terms.add(t);
        }
        return this.evaluatorCompiler.buildExpression(classLoader, conditionBaseClassName, remover, strippedExpression, terms, imports);
    }
}

