/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util.compiler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.evrete.util.compiler.AbstractCompiledClass;

class CompiledClass
extends AbstractCompiledClass {
    private final String packageName;
    private final byte[] bytes;

    CompiledClass(Class<?> cl, byte[] bytes) {
        super(cl.getName(), cl.getName());
        this.packageName = CompiledClass.resolvePackageName(cl);
        this.bytes = bytes;
    }

    private static String resolvePackageName(Class<?> clazz) {
        Package p = clazz.getPackage();
        if (p == null) {
            String name = clazz.getName();
            int lastDot = name.lastIndexOf(46);
            if (lastDot < 0) {
                return "unnamed";
            }
            return name.substring(0, lastDot);
        }
        return p.getName();
    }

    String getPackageName() {
        return this.packageName;
    }

    @Override
    public URI toUri() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }
}

