/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util.compiler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaFileObject;
import org.evrete.util.compiler.CompiledClass;

public class ServiceClassLoader
extends SecureClassLoader {
    private final Map<String, byte[]> resources = new HashMap<String, byte[]>();
    private final List<CompiledClass> localCompiledClasses = new ArrayList<CompiledClass>();

    public ServiceClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Class<?> buildClass(byte[] bytes) {
        Class<?> cl = this.defineClass(null, bytes, 0, bytes.length);
        this.localCompiledClasses.add(new CompiledClass(cl, bytes));
        return cl;
    }

    public void addResource(String name, byte[] bytes) {
        this.resources.put(name, bytes);
    }

    Collection<JavaFileObject> getCompiledClasses(String packageName) {
        ArrayList<JavaFileObject> col = new ArrayList<JavaFileObject>();
        for (ClassLoader current = this; current != null; current = current.getParent()) {
            if (!(current instanceof ServiceClassLoader)) continue;
            ServiceClassLoader scl = current;
            for (CompiledClass cc : scl.localCompiledClasses) {
                if (!cc.getPackageName().equals(packageName)) continue;
                col.add(cc);
            }
        }
        return col;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] bytes = this.resources.get(name);
        if (bytes == null) {
            return super.getResourceAsStream(name);
        }
        return new ByteArrayInputStream(bytes);
    }
}

