/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.compiler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import javax.tools.JavaFileObject;
import org.evrete.runtime.compiler.AbstractJavaObject;

class ClassPathJavaObject
extends AbstractJavaObject {
    private final byte[] bytes;
    private final Class<?> clazz;
    private final URI uri;

    ClassPathJavaObject(Class<?> cl, byte[] bytes) {
        this.bytes = bytes;
        this.clazz = cl;
        this.uri = URI.create("class:///" + cl.getName().replaceAll("\\.", "/") + "." + JavaFileObject.Kind.CLASS.extension);
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return kind.equals((Object)this.getKind()) && simpleName.equals(this.clazz.getSimpleName());
    }

    @Override
    public URI toUri() {
        return this.uri;
    }

    @Override
    public Writer openWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream openOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    String getBinaryName() {
        return this.clazz.getName();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.CLASS;
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }
}

