/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.compiler;

import java.security.SecureClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.tools.JavaFileObject;
import org.evrete.runtime.compiler.ClassPathJavaObject;
import org.evrete.runtime.compiler.DestinationClassObject;
import org.evrete.runtime.compiler.SourceCompiler;

public class RuntimeClassloader
extends SecureClassLoader {
    private static final AtomicLong instanceCounter = new AtomicLong();
    private static final Collection<JavaFileObject> EMPTY = Collections.emptyList();
    private final Map<String, Collection<String>> definedClasses = new ConcurrentHashMap<String, Collection<String>>();
    private final Map<String, byte[]> classDefinitions = new ConcurrentHashMap<String, byte[]>();
    private final long instanceId = instanceCounter.incrementAndGet();

    public RuntimeClassloader(ClassLoader parent) {
        super(parent);
    }

    long getInstanceId() {
        return this.instanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        RuntimeClassloader runtimeClassloader = this;
        synchronized (runtimeClassloader) {
            byte[] bytes = this.classDefinitions.get(name);
            if (bytes == null) {
                throw new ClassNotFoundException("Local class definition not found for '" + name + "'");
            }
            return this.defineClass(null, bytes, 0, bytes.length);
        }
    }

    void saveClass(DestinationClassObject compiled) {
        byte[] classBytes = compiled.getBytes();
        String binaryName = compiled.getBinaryName();
        this.saveClass(binaryName, classBytes);
    }

    void saveClass(String binaryName, byte[] classBytes) {
        String packageName = SourceCompiler.packageName(binaryName);
        this.classDefinitions.put(binaryName, classBytes);
        this.definedClasses.computeIfAbsent(packageName, k -> new LinkedList()).add(binaryName);
    }

    private ClassPathJavaObject getLocallyDefined(String binaryName) {
        byte[] bytes = this.classDefinitions.get(binaryName);
        assert (bytes != null);
        try {
            Class<?> cl = Class.forName(binaryName, false, this);
            return new ClassPathJavaObject(cl, bytes);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    Collection<JavaFileObject> getDefinedClasses(String packageName) {
        Collection<String> classNames = this.definedClasses.get(packageName);
        if (classNames == null) {
            return EMPTY;
        }
        return classNames.stream().map(this::getLocallyDefined).collect(Collectors.toList());
    }
}

