/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.compiler;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.evrete.api.JavaSourceCompiler;
import org.evrete.runtime.compiler.CompilationException;
import org.evrete.runtime.compiler.DestinationClassObject;
import org.evrete.runtime.compiler.InMemoryFileManager;
import org.evrete.runtime.compiler.JavaSource;
import org.evrete.runtime.compiler.RuntimeClassloader;

public class SourceCompiler
implements JavaSourceCompiler {
    private static final String COMPILER_PARAM_OPTION = "-parameters";
    private final RuntimeClassloader classLoader;
    private final JavaCompiler compiler;

    public SourceCompiler(RuntimeClassloader classLoader) {
        this.classLoader = classLoader;
        this.compiler = Objects.requireNonNull(ToolProvider.getSystemJavaCompiler(), "No Java compiler provided by this platform");
    }

    static String packageName(String binaryName) {
        int dotPos = binaryName.lastIndexOf(46);
        if (dotPos < 0) {
            throw new UnsupportedOperationException("Empty/default packages are not supported");
        }
        return binaryName.substring(0, dotPos);
    }

    @Override
    public void defineClass(String binaryName, byte[] classBytes) {
        this.classLoader.saveClass(binaryName, classBytes);
    }

    @Override
    public void compile(Collection<String> sources) throws CompilationException {
        try {
            this.compileUnchecked(sources);
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (Throwable t) {
            String allSources = String.join((CharSequence)"\n", sources);
            throw new CompilationException(t, allSources);
        }
    }

    @Override
    public Class<?> compile(String source) throws CompilationException {
        try {
            Collection result = this.compileUnchecked(Collections.singletonList(source)).stream().map(s -> {
                try {
                    return Class.forName(s, true, this.classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Class has been compiled, but can not be resolved", e);
                }
            }).collect(Collectors.toList());
            for (Class c : result) {
                if (c.getEnclosingClass() != null) continue;
                return c;
            }
            throw new IllegalStateException("No compiled top-level class has been found");
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CompilationException(t, source);
        }
    }

    private Collection<String> compileUnchecked(Collection<String> sources) throws Exception {
        Collection parsedSources = sources.stream().map(s -> JavaSource.parse(this.classLoader.getInstanceId(), s)).collect(Collectors.toCollection(LinkedList::new));
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        try (StandardJavaFileManager systemFm = this.compiler.getStandardFileManager(diagnostics, null, null);
             InMemoryFileManager fm = new InMemoryFileManager(systemFm, this.classLoader, parsedSources);){
            List<String> parameters = this.compiler.isSupportedOption(COMPILER_PARAM_OPTION) < 0 ? Collections.emptyList() : Collections.singletonList(COMPILER_PARAM_OPTION);
            boolean success = this.compiler.getTask(null, fm, diagnostics, parameters, null, parsedSources).call();
            if (success) {
                LinkedList<String> binaryNames = new LinkedList<String>();
                for (DestinationClassObject compiled : fm.getOutput()) {
                    binaryNames.add(compiled.getBinaryName());
                    this.classLoader.saveClass(compiled);
                }
                LinkedList<String> linkedList = binaryNames;
                return linkedList;
            }
            StringJoiner errors = new StringJoiner(", ");
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                errors.add(diagnostic.toString());
            }
            throw new CompilationException("Compilation error(s): " + errors, parsedSources);
        }
    }
}

