/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.Collection;
import java.util.HashSet;
import org.evrete.api.Copyable;
import org.evrete.api.EvaluationListener;
import org.evrete.api.Evaluator;
import org.evrete.api.FieldReference;
import org.evrete.api.IntToValue;
import org.evrete.api.ValuesPredicate;

public class EvaluatorWrapper
implements Evaluator,
Copyable<EvaluatorWrapper> {
    private Evaluator delegate;
    private Collection<EvaluationListener> listeners = new HashSet<EvaluationListener>();
    private final ValuesPredicate verbose = new ValuesPredicate(){

        @Override
        public boolean test(IntToValue intToValue) {
            boolean b = EvaluatorWrapper.this.delegate.test(intToValue);
            for (EvaluationListener listener : EvaluatorWrapper.this.listeners) {
                listener.fire(EvaluatorWrapper.this.delegate, intToValue, b);
            }
            return b;
        }
    };
    private ValuesPredicate active;
    private IntToValue stateValues;

    public EvaluatorWrapper(Evaluator delegate) {
        this.delegate = EvaluatorWrapper.unwrap(delegate);
        this.stateValues = null;
        this.updateActiveEvaluator();
    }

    private EvaluatorWrapper(EvaluatorWrapper other) {
        this.delegate = EvaluatorWrapper.unwrap(other.delegate);
        this.listeners.addAll(other.listeners);
        this.stateValues = null;
        this.updateActiveEvaluator();
    }

    private static Evaluator unwrap(Evaluator e) {
        if (e == null) {
            return null;
        }
        if (e instanceof EvaluatorWrapper) {
            EvaluatorWrapper wrapper = (EvaluatorWrapper)e;
            return EvaluatorWrapper.unwrap(wrapper.delegate);
        }
        return e;
    }

    public String toString() {
        return "{evaluator=" + this.delegate + ", listeners=" + this.listeners + ", hash=" + System.identityHashCode(this) + '}';
    }

    @Override
    public EvaluatorWrapper copyOf() {
        return new EvaluatorWrapper(this);
    }

    public void update(Collection<EvaluationListener> listeners) {
        this.listeners = listeners;
        this.updateActiveEvaluator();
    }

    public Evaluator getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(Evaluator delegate) {
        this.delegate = delegate;
        this.updateActiveEvaluator();
    }

    private void updateActiveEvaluator() {
        this.active = this.listeners.isEmpty() ? this.delegate : this.verbose;
    }

    @Override
    public final boolean test(IntToValue intToValue) {
        return this.active.test(intToValue);
    }

    public final void setStateValues(IntToValue stateValues) {
        this.stateValues = stateValues;
    }

    public final boolean test() {
        return this.test(this.stateValues);
    }

    @Override
    public FieldReference[] descriptor() {
        return this.delegate.descriptor();
    }

    @Override
    public final int compare(Evaluator other) {
        return this.delegate.compare(EvaluatorWrapper.unwrap(other));
    }
}

