/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.evrete.api.Evaluator;
import org.evrete.api.FieldReference;
import org.evrete.api.Imports;
import org.evrete.api.IntToValue;
import org.evrete.api.RuntimeContext;
import org.evrete.runtime.compiler.CompilationException;
import org.evrete.spi.minimal.ConditionStringTerm;
import org.evrete.util.NextIntSupplier;
import org.evrete.util.StringLiteralRemover;

class EvaluatorCompiler {
    private static final String JAVA_EVALUATOR_TEMPLATE = "package %s;\n%s\n\npublic final class %s extends %s {\n    public static final java.lang.invoke.MethodHandle HANDLE;\n\n    static {\n        try {\n            HANDLE = java.lang.invoke.MethodHandles.lookup().findStatic(%s.class, \"__$test\", java.lang.invoke.MethodType.methodType(boolean.class, %s));\n        } catch (Exception e) {\n            throw new IllegalStateException(e);\n        }\n    }\n\n    private static boolean __$testInner(%s) {\n        return %s;\n    }\n\n    public static boolean __$test(%s) {\n        return %s\n    }\n\n    //IMPORTANT LINE BELOW, IT IS USED IN SOURCE/SIGNATURE COMPARISON\n    //%s\n}\n";
    private static final NextIntSupplier javaClassCounter = new NextIntSupplier();
    private final RuntimeContext<?> context;

    EvaluatorCompiler(RuntimeContext<?> context) {
        this.context = context;
    }

    private MethodHandle compileExpression(String classJavaSource) throws CompilationException {
        try {
            Class<?> compiledClass = this.context.getSourceCompiler().compile(classJavaSource);
            return (MethodHandle)compiledClass.getDeclaredField("HANDLE").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new CompilationException(e, classJavaSource);
        }
    }

    Evaluator buildExpression(String baseClassName, StringLiteralRemover remover, String strippedExpression, List<ConditionStringTerm> terms, Imports imports) throws CompilationException {
        int accumulatedShift = 0;
        StringJoiner argClasses = new StringJoiner(", ");
        StringJoiner argTypes = new StringJoiner(", ");
        StringJoiner argCasts = new StringJoiner(", ");
        int castVarIndex = 0;
        StringJoiner methodArgs = new StringJoiner(", ");
        ArrayList<ConditionStringTerm> uniqueReferences = new ArrayList<ConditionStringTerm>();
        ArrayList<ConditionStringTerm> descriptorBuilder = new ArrayList<ConditionStringTerm>();
        for (ConditionStringTerm term : terms) {
            String original = strippedExpression.substring(term.start + accumulatedShift, term.end + accumulatedShift);
            String javaArgVar = term.varName;
            String before = strippedExpression.substring(0, term.start + accumulatedShift);
            String after = strippedExpression.substring(term.end + accumulatedShift);
            strippedExpression = before + javaArgVar + after;
            accumulatedShift += javaArgVar.length() - original.length();
            if (uniqueReferences.contains(term)) continue;
            descriptorBuilder.add(term);
            Class<?> fieldType = term.field().getValueType();
            argTypes.add(term.type().getType().getName() + "/" + term.field().getName());
            argCasts.add("(" + fieldType.getCanonicalName() + ") values.apply(" + castVarIndex + ")");
            argClasses.add(fieldType.getName() + ".class");
            methodArgs.add(fieldType.getCanonicalName() + " " + javaArgVar);
            ++castVarIndex;
            uniqueReferences.add(term);
        }
        StringBuilder importsBuilder = new StringBuilder(1024);
        imports.asJavaImportStatements(importsBuilder);
        String replaced = remover.unwrapLiterals(strippedExpression);
        String pkg = this.getClass().getPackage().getName() + ".compiled";
        String clazz = "Condition" + javaClassCounter.next();
        String javaClassSource = String.format(JAVA_EVALUATOR_TEMPLATE, pkg, importsBuilder, clazz, baseClassName, clazz, IntToValue.class.getName() + ".class", methodArgs, replaced, IntToValue.class.getName() + " values", "__$testInner(" + argCasts + ");", "fields in use: " + argTypes);
        String comparableClassSource = javaClassSource.replaceAll(clazz, "CLASS_STUB");
        FieldReference[] descriptor = descriptorBuilder.toArray(FieldReference.ZERO_ARRAY);
        if (descriptor.length == 0) {
            throw new IllegalArgumentException("No field references were resolved in the '" + strippedExpression + "'");
        }
        MethodHandle methodHandle = this.compileExpression(javaClassSource);
        return new CompiledEvaluator(methodHandle, remover.getOriginal(), javaClassSource, comparableClassSource, descriptor);
    }

    static class CompiledEvaluator
    implements Evaluator {
        private final FieldReference[] descriptor;
        private final MethodHandle methodHandle;
        private final String originalCondition;
        private final String javaClassSource;
        private final String comparableClassSource;

        CompiledEvaluator(MethodHandle methodHandle, String originalCondition, String javaClassSource, String comparableClassSource, FieldReference[] descriptor) {
            this.descriptor = descriptor;
            this.originalCondition = originalCondition;
            this.javaClassSource = javaClassSource;
            this.comparableClassSource = comparableClassSource;
            this.methodHandle = methodHandle;
        }

        String getSource() {
            return this.javaClassSource;
        }

        @Override
        public int compare(Evaluator other) {
            if (other instanceof CompiledEvaluator) {
                CompiledEvaluator o = (CompiledEvaluator)other;
                if (o.descriptor.length == 1 && this.descriptor.length == 1 && o.comparableClassSource.equals(this.comparableClassSource)) {
                    return 1;
                }
            }
            return Evaluator.super.compare(other);
        }

        @Override
        public FieldReference[] descriptor() {
            return this.descriptor;
        }

        @Override
        public boolean test(IntToValue values) {
            try {
                return this.methodHandle.invoke(values);
            }
            catch (SecurityException t) {
                throw t;
            }
            catch (Throwable t) {
                Object[] args = new Object[this.descriptor.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = values.apply(i);
                }
                throw new IllegalStateException("Evaluation exception at '" + this.originalCondition + "', arguments: " + Arrays.toString(this.descriptor) + " -> " + Arrays.toString(args), t);
            }
        }

        public String toString() {
            return "\"" + this.originalCondition + "\"";
        }
    }
}

