/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.async;

import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Predicate;
import org.evrete.api.FactHandleVersioned;
import org.evrete.runtime.KeyMemoryBucket;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.async.Completer;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.Mask;

public class MemoryPurgeTask
extends Completer {
    private static final long serialVersionUID = 7911593735991639599L;
    private final Collection<TypeMemoryTask> subtasks = new LinkedList<TypeMemoryTask>();
    private final transient Mask<MemoryAddress> keyPurgeMask = Mask.addressMask();

    public MemoryPurgeTask(SessionMemory memory, Mask<MemoryAddress> factPurgeMask) {
        for (TypeMemory tm : memory) {
            Predicate<FactHandleVersioned> predicate = handle -> !tm.factExists((FactHandleVersioned)handle);
            for (KeyMemoryBucket bucket : tm) {
                if (!factPurgeMask.get(bucket.address)) continue;
                this.subtasks.add(new TypeMemoryTask(this, bucket, predicate));
            }
        }
    }

    public Mask<MemoryAddress> getKeyPurgeMask() {
        return this.keyPurgeMask;
    }

    @Override
    protected void execute() {
        this.tailCall(this.subtasks, o -> o);
    }

    @Override
    protected void onCompletion() {
        for (TypeMemoryTask sub : this.subtasks) {
            if (!sub.hasEmptyKeys) continue;
            this.keyPurgeMask.set(((TypeMemoryTask)sub).bucket.address);
        }
    }

    static class TypeMemoryTask
    extends Completer {
        private static final long serialVersionUID = 3628304099034857930L;
        private final transient KeyMemoryBucket bucket;
        private final transient Predicate<FactHandleVersioned> predicate;
        private boolean hasEmptyKeys = false;

        TypeMemoryTask(MemoryPurgeTask parent, KeyMemoryBucket bucket, Predicate<FactHandleVersioned> predicate) {
            super(parent);
            this.bucket = bucket;
            this.predicate = predicate;
        }

        private void setHasEmptyKeys() {
            this.hasEmptyKeys = true;
        }

        @Override
        protected void execute() {
            this.bucket.purgeDeleted(this.predicate, k -> this.setHasEmptyKeys());
        }
    }
}

