/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import javax.tools.JavaFileObject;
import org.evrete.runtime.compiler.AbstractJavaObject;

class ClassPathSource
extends AbstractJavaObject {
    private final URI uri;
    private final String binaryName;

    ClassPathSource(String binaryName, URI uri) {
        this.uri = uri;
        this.binaryName = binaryName;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return kind.equals((Object)this.getKind());
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.CLASS;
    }

    @Override
    public Writer openWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream openOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI toUri() {
        return this.uri;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.uri.toURL().openStream();
    }

    @Override
    String getBinaryName() {
        return this.binaryName;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{uri=" + this.uri + '}';
    }
}

