/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.evrete.AbstractRule;
import org.evrete.api.NamedType;
import org.evrete.api.Type;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.DefaultTypeResolver;
import org.evrete.runtime.FactType;
import org.evrete.util.NamedTypeImpl;

public abstract class AbstractRuntimeRule<T extends FactType>
extends AbstractRule {
    final T[] factTypes;
    private final AbstractRuntime<?, ?> runtime;
    private final Map<String, T> typeMapping = new HashMap<String, T>();
    private final DefaultTypeResolver typeResolver = new DefaultTypeResolver();

    AbstractRuntimeRule(AbstractRuntime<?, ?> runtime, AbstractRule other, T[] factTypes) {
        this(runtime, other, other.getName(), other.getSalience(), (FactType[])factTypes);
    }

    AbstractRuntimeRule(AbstractRuntime<?, ?> runtime, AbstractRule other, String ruleName, int salience, T[] factTypes) {
        super(other, ruleName, salience);
        this.runtime = runtime;
        this.factTypes = factTypes;
        for (T factType : factTypes) {
            Type t = runtime.getTypeResolver().getType(((FactType)factType).type());
            NamedTypeImpl namedType = new NamedTypeImpl(t, ((FactType)factType).getName());
            this.typeResolver.save(namedType);
            if (this.typeMapping.put(((FactType)factType).getName(), factType) == null) continue;
            throw new IllegalStateException();
        }
        this.setRhs(this.getLiteralRhs());
    }

    @Override
    public NamedType resolve(String var) {
        return this.typeResolver.resolve(var);
    }

    @Override
    public Collection<NamedType> getDeclaredFactTypes() {
        return this.typeResolver.getDeclaredFactTypes();
    }

    T resolveFactType(NamedType type) {
        return (T)((FactType)this.typeMapping.get(type.getName()));
    }

    public T[] getFactTypes() {
        return this.factTypes;
    }

    @Override
    public final void setRhs(String literalRhs) {
        if (literalRhs != null) {
            LinkedList<NamedType> namedTypes = new LinkedList<NamedType>();
            for (T factType : this.factTypes) {
                namedTypes.add(this.resolve(((FactType)factType).getName()));
            }
            this.setRhs(this.runtime.compile(literalRhs, namedTypes));
        }
    }
}

