/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.evrete.api.Action;
import org.evrete.api.FactHandle;
import org.evrete.api.ReIterator;
import org.evrete.api.Type;
import org.evrete.collections.LinearHashSet;
import org.evrete.runtime.AtomicMemoryAction;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.FactRecordDelta;

public class FactActionBuffer {
    private final Map<Integer, ActionQueue> typedQueues = new ConcurrentHashMap<Integer, ActionQueue>();
    private final int[] actionCounts = new int[Action.values().length];
    private final int capacity;
    private long totalActions = 0L;

    FactActionBuffer(int capacity) {
        this.capacity = capacity;
    }

    boolean hasData() {
        return this.totalActions > 0L;
    }

    private void add(Action action, FactHandle factHandle, FactRecordDelta delta) {
        if (this.get(factHandle).add(action, factHandle, Objects.requireNonNull(delta))) {
            int n = action.ordinal();
            this.actionCounts[n] = this.actionCounts[n] + 1;
            ++this.totalActions;
        }
    }

    AtomicMemoryAction find(FactHandle factHandle) {
        return this.get(factHandle).get(factHandle);
    }

    void clear() {
        Arrays.fill(this.actionCounts, 0);
        this.typedQueues.values().forEach(ActionQueue::clear);
        this.totalActions = 0L;
    }

    int deltaOperations() {
        return this.getCount(Action.INSERT, Action.UPDATE);
    }

    private ActionQueue get(Type<?> t) {
        return this.get(t.getId());
    }

    private ActionQueue get(FactHandle h) {
        return this.get(h.getTypeId());
    }

    private ActionQueue get(int typeId) {
        return this.typedQueues.computeIfAbsent(typeId, i -> new ActionQueue(this.capacity));
    }

    void copyToAndClear(FactActionBuffer other) {
        this.typedQueues.values().forEach((? super T queue) -> ((ActionQueue)queue).queue.forEachDataEntry(a -> other.add(a.action, a.handle, a.getDelta())));
        this.clear();
    }

    private int getCount(Action ... actions) {
        int ret = 0;
        for (Action a : actions) {
            ret += this.actionCounts[a.ordinal()];
        }
        return ret;
    }

    void newUpdate(FactHandle handle, FactRecord previous, Object updatedFact) {
        this.add(Action.UPDATE, handle, FactRecordDelta.updateDelta(previous, updatedFact));
    }

    void newInsert(FactHandle handle, FactRecord record) {
        this.add(Action.INSERT, handle, FactRecordDelta.insertDelta(record));
    }

    public void forEach(Consumer<AtomicMemoryAction> consumer) {
        this.typedQueues.values().forEach((? super T q) -> q.forEachDataEntry(consumer));
    }

    public ReIterator<AtomicMemoryAction> actions(Type<?> type) {
        return this.get(type).queue.iterator();
    }

    public void forEach(Type<?> t, Consumer<AtomicMemoryAction> consumer) {
        this.get(t).forEachDataEntry(consumer);
    }

    void newDelete(FactHandle handle, FactRecord record) {
        this.add(Action.RETRACT, handle, FactRecordDelta.deleteDelta(record));
    }

    private static class ActionQueue {
        private static final BiPredicate<AtomicMemoryAction, FactHandle> SEARCH_FUNCTION = (existing, factHandle) -> existing.handle.equals(factHandle);
        private final LinearHashSet<AtomicMemoryAction> queue;

        ActionQueue(int capacity) {
            this.queue = new LinearHashSet(capacity);
        }

        AtomicMemoryAction get(FactHandle factHandle) {
            int hash = factHandle.hashCode();
            int binIndex = this.queue.findBinIndex((AtomicMemoryAction)((Object)factHandle), hash, SEARCH_FUNCTION);
            return (AtomicMemoryAction)this.queue.get(binIndex);
        }

        void forEachDataEntry(Consumer<AtomicMemoryAction> consumer) {
            this.queue.forEachDataEntry(consumer);
        }

        boolean add(Action action, FactHandle factHandle, FactRecordDelta delta) {
            this.queue.resize();
            int hash = factHandle.hashCode();
            int binIndex = this.queue.findBinIndex((AtomicMemoryAction)((Object)factHandle), hash, SEARCH_FUNCTION);
            AtomicMemoryAction existingAction = (AtomicMemoryAction)this.queue.get(binIndex);
            if (existingAction == null) {
                this.queue.saveDirect(new AtomicMemoryAction(action, factHandle, delta), binIndex);
                return true;
            }
            existingAction.rebuild(action, delta);
            return false;
        }

        void clear() {
            this.queue.clear();
        }
    }
}

