/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.evrete.AbstractRule;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.api.RhsContext;
import org.evrete.api.RuntimeRule;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.AbstractRuntimeRule;
import org.evrete.runtime.BetaEndNode;
import org.evrete.runtime.FactActionBuffer;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RhsFactType;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeFactType;
import org.evrete.runtime.RuntimeLhs;
import org.evrete.runtime.SessionMemory;

public class RuntimeRuleImpl
extends AbstractRuntimeRule<RuntimeFactType>
implements RuntimeRule {
    private final AbstractRuleSession<?> runtime;
    private final RuleDescriptor descriptor;
    private final RuntimeLhs lhs;
    private final RhsGroupNode[] rhsGroupNodes;
    private final RhsFactType[] factTypeNodes;
    private final Map<String, Integer> nameMapping = new HashMap<String, Integer>();
    private final RhsContextImpl rhsContext;
    private final BetaEndNode[] endNodes;
    private long rhsCallCounter = 0L;

    public RuntimeRuleImpl(RuleDescriptor rd, AbstractRuleSession<?> runtime) {
        super(runtime, (AbstractRule)rd, (FactType[])RuntimeRuleImpl.build(runtime, rd.getLhs().getFactTypes()));
        this.descriptor = rd;
        this.runtime = runtime;
        this.lhs = new RuntimeLhs(this, rd.getLhs());
        RhsFactGroup[] rhsFactGroups = this.lhs.getFactGroups();
        this.factTypeNodes = new RhsFactType[rd.factTypes.length];
        for (RhsFactGroup group : rhsFactGroups) {
            for (RuntimeFactType factType : group.types()) {
                int idx = factType.getInRuleIndex();
                RuntimeFactType runtimeFactType = ((RuntimeFactType[])this.getFactTypes())[idx];
                assert (this.factTypeNodes[idx] == null);
                this.factTypeNodes[idx] = new RhsFactType(runtimeFactType);
                if (this.nameMapping.put(factType.getName(), idx) == null) continue;
                throw new IllegalStateException();
            }
        }
        this.rhsGroupNodes = new RhsGroupNode[rhsFactGroups.length];
        for (int i = 0; i < rhsFactGroups.length; ++i) {
            RhsFactGroup g = rhsFactGroups[i];
            RuntimeFactType[] types = g.types();
            this.rhsGroupNodes[i] = types.length == 1 ? new RhsGroupNodeSingle(g, this.factTypeNodes) : new RhsGroupNodeMulti(g, this.factTypeNodes);
        }
        this.endNodes = this.lhs.getEndNodes().toArray(new BetaEndNode[0]);
        this.rhsContext = new RhsContextImpl();
    }

    private static RuntimeFactType[] build(AbstractRuleSession<?> runtime, FactType[] types) {
        SessionMemory memory = runtime.getMemory();
        RuntimeFactType[] arr = new RuntimeFactType[types.length];
        for (int i = 0; i < types.length; ++i) {
            arr[i] = new RuntimeFactType(types[i], memory);
        }
        return arr;
    }

    private void commitDeltas() {
        for (BetaEndNode endNode : this.lhs.getEndNodes()) {
            endNode.commitDelta();
        }
    }

    RuntimeFactType[] asRuntimeTypes(FactType[] types) {
        RuntimeFactType[] arr = new RuntimeFactType[types.length];
        for (int i = 0; i < types.length; ++i) {
            arr[i] = ((RuntimeFactType[])this.getFactTypes())[types[i].getInRuleIndex()];
        }
        return arr;
    }

    final long callRhs(FactActionBuffer destination) {
        this.rhsContext.setBuffer(destination);
        this.rhsCallCounter = 0L;
        for (RhsFactType type : this.factTypeNodes) {
            type.resetState();
        }
        this.forEachFactGroup(0, false, this.rhs.andThen(ctx -> this.increaseCallCount()));
        this.commitDeltas();
        return this.rhsCallCounter;
    }

    public BetaEndNode[] getEndNodes() {
        return this.endNodes;
    }

    private void forEachFactGroup(int group, boolean hasDelta, Consumer<RhsContext> consumer) {
        boolean last = group == this.rhsGroupNodes.length - 1;
        RhsGroupNode factGroup = this.rhsGroupNodes[group];
        for (KeyMode mode : KeyMode.values()) {
            boolean newHasDelta;
            boolean b = mode.isDelta();
            factGroup.initIterator(mode);
            boolean bl = newHasDelta = b || hasDelta;
            if (last) {
                if (!newHasDelta) continue;
                this.forEachKey(0, consumer);
                continue;
            }
            this.forEachFactGroup(group + 1, newHasDelta, consumer);
        }
    }

    private void forEachKey(int group, Consumer<RhsContext> consumer) {
        boolean last;
        RhsGroupNode factGroup = this.rhsGroupNodes[group];
        ReIterator<MemoryKey> iterator = factGroup.keyIterator;
        if (iterator.reset() == 0L) {
            return;
        }
        boolean bl = last = group == this.rhsGroupNodes.length - 1;
        if (last) {
            while (iterator.hasNext()) {
                if (!factGroup.copyKeyState(iterator)) continue;
                this.forEachFact(0, consumer);
            }
        } else {
            while (iterator.hasNext()) {
                if (!factGroup.copyKeyState(iterator)) continue;
                this.forEachKey(group + 1, consumer);
            }
        }
    }

    private void forEachFact(int type, Consumer<RhsContext> consumer) {
        boolean last = type == this.factTypeNodes.length - 1;
        RhsFactType entry = this.factTypeNodes[type];
        ReIterator<FactHandleVersioned> it = entry.factIterator;
        if (it.reset() == 0L) {
            return;
        }
        if (last) {
            while (it.hasNext()) {
                FactHandleVersioned handle = (FactHandleVersioned)it.next();
                if (entry.setCurrentFact(handle)) {
                    consumer.accept(this.rhsContext);
                    continue;
                }
                it.remove();
            }
        } else {
            while (it.hasNext()) {
                FactHandleVersioned handle = (FactHandleVersioned)it.next();
                if (entry.setCurrentFact(handle)) {
                    this.forEachFact(type + 1, consumer);
                    continue;
                }
                it.remove();
            }
        }
    }

    private void increaseCallCount() {
        ++this.rhsCallCounter;
    }

    public void clear() {
        for (BetaEndNode endNode : this.lhs.getEndNodes()) {
            endNode.clear();
        }
    }

    @Override
    public RuntimeRule set(String property, Object value) {
        super.set(property, value);
        return this;
    }

    public RuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public AbstractRuleSession<?> getRuntime() {
        return this.runtime;
    }

    public RuntimeLhs getLhs() {
        return this.lhs;
    }

    public String toString() {
        return "RuntimeRule{name='" + this.getName() + "'}";
    }

    static abstract class RhsGroupNode {
        final RhsFactGroup group;
        ReIterator<MemoryKey> keyIterator;

        RhsGroupNode(RhsFactGroup group) {
            this.group = group;
        }

        final void initIterator(KeyMode mode) {
            this.keyIterator = this.group.keyIterator(mode);
        }

        abstract boolean copyKeyState(ReIterator<MemoryKey> var1);

        public String toString() {
            return this.group.toString();
        }
    }

    static class RhsGroupNodeSingle
    extends RhsGroupNode {
        final RhsFactType factTypeNode;

        RhsGroupNodeSingle(RhsFactGroup group, RhsFactType[] factTypeNodes) {
            super(group);
            this.factTypeNode = factTypeNodes[group.types()[0].getInRuleIndex()];
        }

        @Override
        boolean copyKeyState(ReIterator<MemoryKey> iterator) {
            MemoryKey key = (MemoryKey)iterator.next();
            this.factTypeNode.setCurrentKey(key);
            return key.getMetaValue() != -1;
        }
    }

    static class RhsGroupNodeMulti
    extends RhsGroupNode {
        final RhsFactType[] myFactTypeNodes;

        RhsGroupNodeMulti(RhsFactGroup group, RhsFactType[] factTypeNodes) {
            super(group);
            RuntimeFactType[] types = group.types();
            this.myFactTypeNodes = new RhsFactType[types.length];
            for (int i = 0; i < types.length; ++i) {
                this.myFactTypeNodes[i] = factTypeNodes[types[i].getInRuleIndex()];
            }
        }

        @Override
        boolean copyKeyState(ReIterator<MemoryKey> iterator) {
            boolean ret = true;
            for (RhsFactType t : this.myFactTypeNodes) {
                MemoryKey key = (MemoryKey)iterator.next();
                ret &= key.getMetaValue() != -1;
                t.setCurrentKey(key);
            }
            return ret;
        }
    }

    private class RhsContextImpl
    implements RhsContext {
        private FactActionBuffer buffer;

        private RhsContextImpl() {
        }

        void setBuffer(FactActionBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public RhsContext insert(Object fact, boolean resolveCollections) {
            RuntimeRuleImpl.this.runtime.bufferInsert(fact, resolveCollections, this.buffer);
            return this;
        }

        @Override
        public final RhsContext update(Object obj) {
            Objects.requireNonNull(obj);
            for (RhsFactType state : RuntimeRuleImpl.this.factTypeNodes) {
                if (state.record.instance != obj) continue;
                AbstractRuleSession.bufferUpdate(state.handle, state.record, obj, this.buffer);
                return this;
            }
            throw new IllegalArgumentException("Fact " + obj + " not found in current RHS context");
        }

        @Override
        public final RhsContext delete(Object obj) {
            Objects.requireNonNull(obj);
            for (RhsFactType state : RuntimeRuleImpl.this.factTypeNodes) {
                if (state.record.instance != obj) continue;
                AbstractRuleSession.bufferDelete(state.handle, state.record, this.buffer);
                return this;
            }
            throw new IllegalArgumentException("Fact " + obj + " not found in current RHS context");
        }

        @Override
        public RuntimeRule getRule() {
            return RuntimeRuleImpl.this;
        }

        @Override
        public Object getObject(String name) {
            Integer idx = (Integer)RuntimeRuleImpl.this.nameMapping.get(name);
            if (idx == null) {
                throw new IllegalArgumentException("Unknown type reference: " + name);
            }
            return ((RuntimeRuleImpl)RuntimeRuleImpl.this).factTypeNodes[idx.intValue()].record.instance;
        }
    }
}

