/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.compiler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.tools.JavaFileObject;
import org.evrete.runtime.compiler.ClassMeta;
import org.evrete.runtime.compiler.ClassPathJavaObject;
import org.evrete.runtime.compiler.DestinationClassObject;

public class RuntimeClassloader
extends ClassLoader {
    private static final Collection<JavaFileObject> EMPTY = Collections.emptyList();
    private final Map<String, Collection<String>> definedClasses = new ConcurrentHashMap<String, Collection<String>>();
    private final Map<String, byte[]> classDefinitions = new ConcurrentHashMap<String, byte[]>();

    public RuntimeClassloader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        RuntimeClassloader runtimeClassloader = this;
        synchronized (runtimeClassloader) {
            byte[] bytes = this.classDefinitions.get(name);
            if (bytes == null) {
                throw new ClassNotFoundException("Local class definition not found for '" + name + "'");
            }
            return this.defineClass(name, bytes, 0, bytes.length);
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        int pos = name.lastIndexOf(".class");
        if (pos < 0) {
            return super.getResourceAsStream(name);
        }
        String noExtension = name.substring(0, pos);
        String binaryName = noExtension.replaceAll("/", ".");
        byte[] bytes = this.classDefinitions.get(binaryName);
        if (bytes == null) {
            return super.getResourceAsStream(name);
        }
        return new ByteArrayInputStream(bytes);
    }

    void saveClass(DestinationClassObject compiled) {
        byte[] classBytes = compiled.getBytes();
        String binaryName = compiled.getBinaryName();
        this.saveClass(binaryName, classBytes);
    }

    void saveClass(String binaryName, byte[] classBytes) {
        ClassMeta meta = new ClassMeta(binaryName);
        this.classDefinitions.put(binaryName, classBytes);
        this.definedClasses.computeIfAbsent(meta.getPackageName(), k -> new LinkedList()).add(binaryName);
    }

    private ClassPathJavaObject getLocallyDefined(String binaryName) {
        byte[] bytes = this.classDefinitions.get(binaryName);
        assert (bytes != null);
        try {
            Class<?> cl = Class.forName(binaryName, false, this);
            return new ClassPathJavaObject(cl, bytes);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    Collection<JavaFileObject> getDefinedClasses(String packageName) {
        Collection<String> classNames = this.definedClasses.get(packageName);
        if (classNames == null) {
            return EMPTY;
        }
        return classNames.stream().map(this::getLocallyDefined).collect(Collectors.toList());
    }
}

