/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import org.evrete.api.Evaluator;
import org.evrete.api.FieldReference;
import org.evrete.api.IntToValue;
import org.evrete.api.LiteralEvaluator;
import org.evrete.api.LiteralExpression;
import org.evrete.spi.minimal.EvaluatorClassSource;

class CompiledEvaluator
implements LiteralEvaluator {
    private final FieldReference[] descriptor;
    private final MethodHandle methodHandle;
    private final LiteralExpression source;
    private final String originalCondition;
    private final String javaClassSource;
    private final String comparableClassSource;

    CompiledEvaluator(MethodHandle methodHandle, EvaluatorClassSource source) {
        this.source = source.getExpression();
        this.descriptor = source.getDescriptor();
        this.originalCondition = source.getExpression().getSource();
        this.javaClassSource = source.getSource();
        this.comparableClassSource = source.getComparableClassSource();
        this.methodHandle = methodHandle;
    }

    @Override
    public LiteralExpression getSource() {
        return this.source;
    }

    String getJavaSource() {
        return this.javaClassSource;
    }

    @Override
    public int compare(Evaluator other) {
        if (other instanceof CompiledEvaluator) {
            CompiledEvaluator o = (CompiledEvaluator)other;
            if (o.descriptor.length == 1 && this.descriptor.length == 1 && o.comparableClassSource.equals(this.comparableClassSource)) {
                return 1;
            }
        }
        return LiteralEvaluator.super.compare(other);
    }

    @Override
    public FieldReference[] descriptor() {
        return this.descriptor;
    }

    @Override
    public boolean test(IntToValue values) {
        try {
            return this.methodHandle.invoke(values);
        }
        catch (SecurityException t) {
            throw t;
        }
        catch (Throwable t) {
            Object[] args = new Object[this.descriptor.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = values.apply(i);
            }
            throw new IllegalStateException("Evaluation exception at '" + this.originalCondition + "', arguments: " + Arrays.toString(this.descriptor) + " -> " + Arrays.toString(args), t);
        }
    }

    public String toString() {
        return "\"" + this.originalCondition + "\"";
    }
}

