/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.evrete.api.FactHandle;
import org.evrete.api.RuleSession;
import org.evrete.api.SessionLifecycleListener;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.ActivationContext;
import org.evrete.runtime.BetaEndNode;
import org.evrete.runtime.DeltaMemoryStatus;
import org.evrete.runtime.FactActionBuffer;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.KeyMemoryBucket;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.async.Completer;
import org.evrete.runtime.async.ComputeDeltaMemoryTask;
import org.evrete.runtime.async.ConditionMemoryPurgeTask;
import org.evrete.runtime.async.ForkJoinExecutor;
import org.evrete.runtime.async.MemoryPurgeTask;
import org.evrete.runtime.async.RuleMemoryInsertTask;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.Mask;

abstract class AbstractRuleSessionIO<S extends RuleSession<S>>
extends AbstractRuleSession<S> {
    AbstractRuleSessionIO(KnowledgeRuntime knowledge) {
        super(knowledge);
    }

    void fireInner() {
        for (SessionLifecycleListener e : this.lifecycleListeners) {
            e.onEvent(SessionLifecycleListener.Event.PRE_FIRE);
        }
        switch (this.getAgendaMode()) {
            case DEFAULT: {
                this.fireDefault(new ActivationContext());
                break;
            }
            case CONTINUOUS: {
                this.fireContinuous(new ActivationContext());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode " + (Object)((Object)this.getAgendaMode()));
            }
        }
    }

    private void fireDefault(ActivationContext ctx) {
        Mask<MemoryAddress> deleteMask = Mask.addressMask();
        FactActionBuffer buff = this.newActionBuffer();
        while (this.fireCriteriaMet() && this.actionBuffer.hasData()) {
            DeltaMemoryStatus deltaStatus = this.buildDeltaMemory();
            List<RuntimeRuleImpl> agenda = deltaStatus.getAgenda();
            if (!agenda.isEmpty()) {
                this.activationManager.onAgenda(ctx.incrementFireCount(), Collections.unmodifiableList(agenda));
                for (RuntimeRuleImpl rule : agenda) {
                    if (!this.activationManager.test(rule)) continue;
                    this.activationManager.onActivation(rule, rule.callRhs(buff));
                    buff.copyToAndClear(this.actionBuffer);
                }
            }
            deltaStatus.commitDeltas();
            deleteMask.or(deltaStatus.getDeleteMask());
        }
        this.purge(deleteMask);
    }

    private void fireContinuous(ActivationContext ctx) {
        Mask<MemoryAddress> deleteMask = Mask.addressMask();
        FactActionBuffer buff = this.newActionBuffer();
        while (this.fireCriteriaMet() && this.actionBuffer.hasData()) {
            DeltaMemoryStatus deltaStatus = this.buildDeltaMemory();
            List<RuntimeRuleImpl> agenda = deltaStatus.getAgenda();
            if (!agenda.isEmpty()) {
                this.activationManager.onAgenda(ctx.incrementFireCount(), Collections.unmodifiableList(agenda));
                for (RuntimeRuleImpl rule : agenda) {
                    if (!this.activationManager.test(rule)) continue;
                    this.activationManager.onActivation(rule, rule.callRhs(buff));
                }
                buff.copyToAndClear(this.actionBuffer);
            }
            deltaStatus.commitDeltas();
            deleteMask.or(deltaStatus.getDeleteMask());
        }
        this.purge(deleteMask);
    }

    private DeltaMemoryStatus buildDeltaMemory() {
        ComputeDeltaMemoryTask deltaTask = new ComputeDeltaMemoryTask(this.actionBuffer, this.memory);
        this.getExecutor().invoke(deltaTask);
        Mask<MemoryAddress> deleteMask = deltaTask.getDeleteMask();
        Collection<KeyMemoryBucket> bucketsToCommit = deltaTask.getBucketsToCommit();
        Mask<MemoryAddress> insertMask = Mask.addressMask();
        for (KeyMemoryBucket v : bucketsToCommit) {
            insertMask.set(v.address);
        }
        List<RuntimeRuleImpl> agenda = this.buildMemoryDeltas(insertMask);
        DeltaMemoryStatus status = new DeltaMemoryStatus(deleteMask, bucketsToCommit, agenda);
        this.actionBuffer.clear();
        return status;
    }

    private List<RuntimeRuleImpl> buildMemoryDeltas(Mask<MemoryAddress> matchMask) {
        LinkedList<RuntimeRuleImpl> affectedRules = new LinkedList<RuntimeRuleImpl>();
        HashSet<BetaEndNode> affectedEndNodes = new HashSet<BetaEndNode>();
        for (RuntimeRuleImpl rule : this.ruleStorage) {
            boolean ruleAdded = false;
            for (RhsFactGroup group : rule.getLhs().getFactGroups()) {
                if (!matchMask.intersects(group.getMemoryMask())) continue;
                if (!ruleAdded) {
                    affectedRules.add(rule);
                    ruleAdded = true;
                }
                if (!(group instanceof BetaEndNode)) continue;
                affectedEndNodes.add((BetaEndNode)group);
            }
        }
        LinkedList<RuleMemoryInsertTask> tasks = new LinkedList<RuleMemoryInsertTask>();
        if (!affectedEndNodes.isEmpty()) {
            tasks.add(new RuleMemoryInsertTask(affectedEndNodes, matchMask, true));
        }
        if (tasks.size() > 0) {
            ForkJoinExecutor executor = this.getExecutor();
            for (Completer completer : tasks) {
                executor.invoke(completer);
            }
        }
        return affectedRules;
    }

    private void purge(Mask<MemoryAddress> factPurgeMask) {
        if (factPurgeMask.cardinality() > 0) {
            ForkJoinExecutor executor = this.getExecutor();
            MemoryPurgeTask purgeTask = new MemoryPurgeTask(this.memory, factPurgeMask);
            executor.invoke(purgeTask);
            Mask<MemoryAddress> emptyKeysMask = purgeTask.getKeyPurgeMask();
            if (emptyKeysMask.cardinality() > 0) {
                executor.invoke(new ConditionMemoryPurgeTask(this.ruleStorage, emptyKeysMask));
            }
        }
    }

    @Override
    void bufferUpdate(FactHandle handle, FactRecord previous, Object updatedFact) {
        AbstractRuleSessionIO.bufferUpdate(handle, previous, updatedFact, this.actionBuffer);
    }

    @Override
    void bufferDelete(FactHandle handle) {
        FactRecord existing = this.getFactRecord(handle);
        if (existing != null) {
            AbstractRuleSessionIO.bufferDelete(handle, existing, this.actionBuffer);
        }
    }

    @Override
    public FactHandle insert0(Object fact, boolean resolveCollections) {
        return this.bufferInsert(fact, resolveCollections, this.actionBuffer);
    }

    @Override
    public FactHandle insert0(String type, Object fact, boolean resolveCollections) {
        return this.bufferInsert(fact, type, resolveCollections, this.actionBuffer);
    }
}

