/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.evrete.Configuration;
import org.evrete.KnowledgeService;
import org.evrete.api.ActivationManager;
import org.evrete.api.ActivationMode;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.ExpressionResolver;
import org.evrete.api.FieldReference;
import org.evrete.api.JavaSourceCompiler;
import org.evrete.api.NamedType;
import org.evrete.api.RhsContext;
import org.evrete.api.Rule;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuleBuilderExceptionHandler;
import org.evrete.api.RuleSetContext;
import org.evrete.api.RuntimeContext;
import org.evrete.api.TypeField;
import org.evrete.api.TypeResolver;
import org.evrete.runtime.FactType;
import org.evrete.runtime.LhsConditionHandles;
import org.evrete.runtime.LhsConditions;
import org.evrete.runtime.RuleBuilderImpl;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeMetaData;
import org.evrete.runtime.async.ForkJoinExecutor;
import org.evrete.runtime.compiler.CompilationException;
import org.evrete.runtime.compiler.RuntimeClassloader;
import org.evrete.runtime.compiler.SourceCompiler;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.DefaultActivationManager;

public abstract class AbstractRuntime<R extends Rule, C extends RuntimeContext<C>>
extends RuntimeMetaData<C>
implements RuleSetContext<C, R> {
    private static final Logger LOGGER = Logger.getLogger(AbstractRuntime.class.getName());
    private final List<RuleBuilder<C>> ruleBuilders = new ArrayList<RuleBuilder<C>>();
    private final KnowledgeService service;
    private final Configuration configuration;
    private final AtomicInteger noNameRuleCounter;
    private ExpressionResolver expressionResolver;
    private Comparator<Rule> ruleComparator = SALIENCE_COMPARATOR;
    private Class<? extends ActivationManager> activationManagerFactory;
    private ActivationMode agendaMode;
    private RuleBuilderExceptionHandler ruleBuilderExceptionHandler;
    private RuntimeClassloader classloader;

    AbstractRuntime(KnowledgeService service, TypeResolver typeResolver) {
        super(service, typeResolver);
        this.configuration = service.getConfiguration().copyOf();
        this.classloader = new RuntimeClassloader(service.getClassLoader());
        this.service = service;
        this.activationManagerFactory = DefaultActivationManager.class;
        this.agendaMode = ActivationMode.DEFAULT;
        this.ruleBuilderExceptionHandler = (context, ruleBuilder, e) -> {
            throw e;
        };
        this.noNameRuleCounter = new AtomicInteger();
    }

    AbstractRuntime(KnowledgeService service) {
        this(service, service.newTypeResolver());
    }

    AbstractRuntime(AbstractRuntime<?, ?> parent) {
        super(parent);
        this.configuration = parent.configuration.copyOf();
        this.service = parent.service;
        this.ruleComparator = parent.ruleComparator;
        this.activationManagerFactory = parent.activationManagerFactory;
        this.agendaMode = parent.agendaMode;
        this.expressionResolver = null;
        this.ruleBuilderExceptionHandler = parent.ruleBuilderExceptionHandler;
        this.noNameRuleCounter = parent.noNameRuleCounter;
        this.classloader = new RuntimeClassloader(parent.classloader);
    }

    protected abstract void addRuleInner(RuleBuilder<?> var1) throws CompilationException;

    ActivationMode getAgendaMode() {
        return this.agendaMode;
    }

    @Override
    public final void addRule(RuleBuilder<?> builder) {
        try {
            this.addRuleInner(builder);
        }
        catch (RuntimeException e) {
            this.ruleBuilderExceptionHandler.handle(this, builder, e);
        }
        catch (CompilationException e) {
            e.log(LOGGER, Level.WARNING);
            this.ruleBuilderExceptionHandler.handle(this, builder, new RuntimeException(e));
        }
    }

    @Override
    public final RuntimeClassloader getClassLoader() {
        return this.classloader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classloader = new RuntimeClassloader(classLoader);
    }

    @Override
    public void setRuleBuilderExceptionHandler(RuleBuilderExceptionHandler handler) {
        this.ruleBuilderExceptionHandler = handler;
    }

    @Override
    public final JavaSourceCompiler getSourceCompiler() {
        return new SourceCompiler(this.classloader);
    }

    @Override
    public C setActivationMode(ActivationMode activationMode) {
        this._assertActive();
        this.agendaMode = activationMode;
        return (C)this;
    }

    @Override
    public KnowledgeService getService() {
        this._assertActive();
        return this.service;
    }

    @Override
    public Class<? extends ActivationManager> getActivationManagerFactory() {
        this._assertActive();
        return this.activationManagerFactory;
    }

    @Override
    public <A extends ActivationManager> void setActivationManagerFactory(Class<A> managerClass) {
        this._assertActive();
        this.activationManagerFactory = managerClass;
    }

    @Override
    public final void setActivationManagerFactory(String managerClass) {
        this._assertActive();
        try {
            Class<?> factory = Class.forName(managerClass, true, this.getClassLoader());
            this.setActivationManagerFactory(factory);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(managerClass);
        }
    }

    ActivationManager newActivationManager() {
        try {
            return this.activationManagerFactory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to create activation manager. Probably the provided factory class has no public and zero-argument constructor.", e);
        }
    }

    @Override
    public Comparator<Rule> getRuleComparator() {
        return this.ruleComparator;
    }

    @Override
    public void setRuleComparator(Comparator<Rule> ruleComparator) {
        this._assertActive();
        this.ruleComparator = ruleComparator;
    }

    ForkJoinExecutor getExecutor() {
        this._assertActive();
        return this.service.getExecutor();
    }

    FactType buildFactType(NamedType builder, Set<TypeField> fields, Set<EvaluatorHandle> alphaEvaluators, int inRuleId) {
        this._assertActive();
        MemoryAddress memoryAddress = this.buildMemoryAddress(builder.getType(), fields, alphaEvaluators);
        return new FactType(builder.getName(), memoryAddress, inRuleId);
    }

    @Override
    public RuleBuilder<C> newRule() {
        return this.newRule("rule_" + this.noNameRuleCounter.incrementAndGet());
    }

    @Override
    public RuleBuilder<C> newRule(String name) {
        this._assertActive();
        RuleBuilderImpl rb = new RuleBuilderImpl(this, name);
        this.ruleBuilders.add(rb);
        return rb;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    synchronized RuleDescriptor compileRuleBuilder(RuleBuilderImpl<?> ruleBuilder) throws CompilationException {
        Function<RuleBuilderImpl<?>, LhsConditionHandles> func = LhsConditions.compile(this, Collections.singletonList(ruleBuilder));
        return this.compileRuleBuilder(ruleBuilder, func);
    }

    synchronized RuleDescriptor compileRuleBuilder(RuleBuilderImpl<?> ruleBuilder, Function<RuleBuilderImpl<?>, LhsConditionHandles> lhsConditions) {
        this._assertActive();
        if (!this.ruleBuilders.remove(ruleBuilder)) {
            throw new IllegalArgumentException("No such rule builder");
        }
        int currentRuleCount = this.getRules().size();
        String ruleName = ruleBuilder.getName();
        int salience = ruleBuilder.getSalience();
        if (salience == Integer.MIN_VALUE) {
            salience = -1 * (currentRuleCount + 1);
        }
        if (this.ruleExists(ruleBuilder.getName())) {
            throw new IllegalArgumentException("Rule '" + ruleBuilder.getName() + "' already exists");
        }
        return RuleDescriptor.factory(this, ruleBuilder, lhsConditions.apply(ruleBuilder), ruleName, salience);
    }

    Consumer<RhsContext> compile(String literalRhs, Collection<NamedType> namedTypes) {
        this._assertActive();
        try {
            return this.service.getLiteralRhsCompiler().compileRhs(this, literalRhs, namedTypes);
        }
        catch (CompilationException e) {
            e.log(LOGGER, Level.WARNING);
            throw new IllegalStateException(e);
        }
    }

    private FieldReference resolveFieldReference(String arg, NamedType.Resolver typeMapper) {
        this._assertActive();
        return this.getExpressionResolver().resolve(arg, typeMapper);
    }

    @Override
    public FieldReference[] resolveFieldReferences(String[] arg, NamedType.Resolver typeMapper) {
        this._assertActive();
        FieldReference[] refs = new FieldReference[arg.length];
        for (int i = 0; i < arg.length; ++i) {
            refs[i] = this.resolveFieldReference(arg[i], typeMapper);
        }
        return refs;
    }

    @Override
    public final synchronized ExpressionResolver getExpressionResolver() {
        this._assertActive();
        if (this.expressionResolver == null) {
            this.expressionResolver = this.service.getExpressionResolverProvider().instance(this);
        }
        return this.expressionResolver;
    }

    abstract void _assertActive();
}

