/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.KeyMode;
import org.evrete.api.KeyedFactStorage;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueHandle;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.MemoryComponent;
import org.evrete.runtime.RuntimeFact;
import org.evrete.runtime.evaluation.MemoryAddress;

public abstract class KeyMemoryBucket
extends MemoryComponent {
    public final MemoryAddress address;
    final KeyedFactStorage fieldData;
    final ActiveField[] activeFields;
    final Collection<FactHandleVersioned> buffer = new LinkedList<FactHandleVersioned>();
    RuntimeFact current = null;

    KeyMemoryBucket(MemoryComponent runtime, MemoryAddress address) {
        super(runtime);
        FieldsKey fields = address.fields();
        this.fieldData = this.memoryFactory.newBetaStorage(fields.getFields().length);
        this.activeFields = fields.getFields();
        this.address = address;
    }

    static KeyMemoryBucket factory(MemoryComponent runtime, MemoryAddress address) {
        int fieldCount = address.fields().size();
        if (address.isEmpty()) {
            switch (fieldCount) {
                case 0: {
                    return new KeyMemoryBucketNoAlpha.KeyMemoryBucketNoAlpha0(runtime, address);
                }
                case 1: {
                    return new KeyMemoryBucketNoAlpha.KeyMemoryBucketNoAlpha1(runtime, address);
                }
            }
            return new KeyMemoryBucketNoAlpha.KeyMemoryBucketNoAlphaN(runtime, address);
        }
        switch (fieldCount) {
            case 0: {
                return new KeyMemoryBucketAlpha.KeyMemoryBucketAlpha0(runtime, address);
            }
            case 1: {
                return new KeyMemoryBucketAlpha.KeyMemoryBucketAlpha1(runtime, address);
            }
        }
        return new KeyMemoryBucketAlpha.KeyMemoryBucketAlphaN(runtime, address);
    }

    public void purgeDeleted(Predicate<FactHandleVersioned> predicate, Consumer<MemoryKey> emptyKeysConsumer) {
        ReIterator<MemoryKey> keys = this.fieldData.keys(KeyMode.OLD_OLD);
        while (keys.hasNext()) {
            MemoryKey key = (MemoryKey)keys.next();
            ReIterator<FactHandleVersioned> handles = this.fieldData.values(KeyMode.OLD_OLD, key);
            while (handles.hasNext()) {
                FactHandleVersioned handle = (FactHandleVersioned)handles.next();
                if (!predicate.test(handle)) continue;
                handles.remove();
            }
            long remaining = handles.reset();
            if (remaining != 0L) continue;
            key.setMetaValue(-1);
            emptyKeysConsumer.accept(key);
            keys.remove();
        }
    }

    ValueHandle currentFactField(ActiveField field) {
        return this.current.getValue(field);
    }

    abstract void flushBuffer();

    public abstract boolean insert(Iterable<RuntimeFact> var1);

    @Override
    protected final void clearLocalData() {
        this.fieldData.clear();
        this.buffer.clear();
    }

    public final KeyedFactStorage getFieldData() {
        return this.fieldData;
    }

    void commitBuffer() {
        this.fieldData.commitChanges();
    }

    public final String toString() {
        return this.fieldData.toString();
    }

    static abstract class KeyMemoryBucketNoAlpha
    extends KeyMemoryBucket {
        KeyMemoryBucketNoAlpha(MemoryComponent runtime, MemoryAddress address) {
            super(runtime, address);
        }

        @Override
        public final boolean insert(Iterable<RuntimeFact> facts) {
            this.current = RuntimeFact.DUMMY_FACT;
            boolean ret = false;
            for (RuntimeFact fact : facts) {
                ret = true;
                fact.factRecord.markLocation(this.address);
                if (this.current.sameValues(fact)) {
                    this.buffer.add(fact.factHandle);
                    continue;
                }
                this.flushBuffer();
                this.buffer.add(fact.factHandle);
                this.current = fact;
            }
            if (!this.buffer.isEmpty()) {
                this.flushBuffer();
            }
            return ret;
        }

        static class KeyMemoryBucketNoAlphaN
        extends KeyMemoryBucketNoAlpha {
            KeyMemoryBucketNoAlphaN(MemoryComponent runtime, MemoryAddress address) {
                super(runtime, address);
            }

            @Override
            final void flushBuffer() {
                if (this.current != RuntimeFact.DUMMY_FACT) {
                    for (ActiveField field : this.activeFields) {
                        this.fieldData.write(this.currentFactField(field));
                    }
                    this.fieldData.write(this.buffer);
                    this.buffer.clear();
                }
            }
        }

        static class KeyMemoryBucketNoAlpha1
        extends KeyMemoryBucketNoAlpha {
            private final ActiveField field;

            KeyMemoryBucketNoAlpha1(MemoryComponent runtime, MemoryAddress address) {
                super(runtime, address);
                assert (address.fields().size() == 1);
                this.field = address.fields().getFields()[0];
            }

            @Override
            final void flushBuffer() {
                if (this.current != RuntimeFact.DUMMY_FACT) {
                    this.fieldData.write(this.currentFactField(this.field));
                    this.fieldData.write(this.buffer);
                    this.buffer.clear();
                }
            }
        }

        static class KeyMemoryBucketNoAlpha0
        extends KeyMemoryBucketNoAlpha {
            KeyMemoryBucketNoAlpha0(MemoryComponent runtime, MemoryAddress address) {
                super(runtime, address);
            }

            @Override
            final void flushBuffer() {
                if (this.current != RuntimeFact.DUMMY_FACT) {
                    this.fieldData.write(this.buffer);
                    this.buffer.clear();
                }
            }
        }
    }

    static abstract class KeyMemoryBucketAlpha
    extends KeyMemoryBucket {
        KeyMemoryBucketAlpha(MemoryComponent runtime, MemoryAddress address) {
            super(runtime, address);
        }

        @Override
        public final boolean insert(Iterable<RuntimeFact> facts) {
            this.current = RuntimeFact.DUMMY_FACT;
            boolean ret = false;
            for (RuntimeFact fact : facts) {
                if (!this.address.testAlphaBits(fact.alphaTests)) continue;
                ret = true;
                fact.factRecord.markLocation(this.address);
                if (this.current.sameValues(fact)) {
                    this.buffer.add(fact.factHandle);
                    continue;
                }
                this.flushBuffer();
                this.buffer.add(fact.factHandle);
                this.current = fact;
            }
            if (!this.buffer.isEmpty()) {
                this.flushBuffer();
            }
            return ret;
        }

        static class KeyMemoryBucketAlphaN
        extends KeyMemoryBucketAlpha {
            KeyMemoryBucketAlphaN(MemoryComponent runtime, MemoryAddress address) {
                super(runtime, address);
            }

            @Override
            final void flushBuffer() {
                if (this.current != RuntimeFact.DUMMY_FACT) {
                    for (ActiveField field : this.activeFields) {
                        this.fieldData.write(this.currentFactField(field));
                    }
                    this.fieldData.write(this.buffer);
                    this.buffer.clear();
                }
            }
        }

        static class KeyMemoryBucketAlpha1
        extends KeyMemoryBucketAlpha {
            private final ActiveField field;

            KeyMemoryBucketAlpha1(MemoryComponent runtime, MemoryAddress address) {
                super(runtime, address);
                assert (address.fields().size() == 1);
                this.field = address.fields().getFields()[0];
            }

            @Override
            final void flushBuffer() {
                if (this.current != RuntimeFact.DUMMY_FACT) {
                    this.fieldData.write(this.currentFactField(this.field));
                    this.fieldData.write(this.buffer);
                    this.buffer.clear();
                }
            }
        }

        static class KeyMemoryBucketAlpha0
        extends KeyMemoryBucketAlpha {
            KeyMemoryBucketAlpha0(MemoryComponent runtime, MemoryAddress address) {
                super(runtime, address);
            }

            @Override
            final void flushBuffer() {
                if (this.current != RuntimeFact.DUMMY_FACT) {
                    this.fieldData.write(this.buffer);
                    this.buffer.clear();
                }
            }
        }
    }
}

