/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.evrete.api.Evaluator;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.LiteralEvaluator;
import org.evrete.api.LiteralExpression;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.LhsConditionHandles;
import org.evrete.runtime.LhsConditionsHolder;
import org.evrete.runtime.compiler.CompilationException;

class LhsConditions {
    private final Collection<EvaluatorHandle> directHandles = new LinkedList<EvaluatorHandle>();
    private final Collection<WithComplexity<Evaluator>> evaluators = new LinkedList<WithComplexity<Evaluator>>();
    private final Collection<WithComplexity<LiteralExpression>> literals = new LinkedList<WithComplexity<LiteralExpression>>();

    LhsConditions() {
    }

    void add(Evaluator evaluator, double complexity) {
        this.evaluators.add(new WithComplexity<Evaluator>(Objects.requireNonNull(evaluator), complexity));
    }

    void add(LiteralExpression expression, double complexity) {
        this.literals.add(new WithComplexity<LiteralExpression>(Objects.requireNonNull(expression), complexity));
    }

    void add(EvaluatorHandle handle) {
        this.directHandles.add(Objects.requireNonNull(handle));
    }

    static <T extends LhsConditionsHolder> Function<T, LhsConditionHandles> compile(AbstractRuntime<?, ?> runtime, Collection<T> sources) throws CompilationException {
        IdentityHashMap<LhsConditionsHolder, LhsConditionHandles> map = new IdentityHashMap<LhsConditionsHolder, LhsConditionHandles>();
        IdentityHashMap<LiteralExpression, LiteralExpressionHelper<LhsConditionsHolder>> allExpressions = new IdentityHashMap<LiteralExpression, LiteralExpressionHelper<LhsConditionsHolder>>();
        for (LhsConditionsHolder source : sources) {
            LhsConditions conditions = source.getConditions();
            for (WithComplexity<LiteralExpression> withComplexity : conditions.literals) {
                allExpressions.put((LiteralExpression)withComplexity.subject, new LiteralExpressionHelper<LhsConditionsHolder>(source, withComplexity.complexity));
            }
        }
        Set<LiteralExpression> allSources = allExpressions.keySet();
        IdentityHashMap<LhsConditionsHolder, Collection> perSourceLiterals = new IdentityHashMap<LhsConditionsHolder, Collection>();
        if (!allSources.isEmpty()) {
            Collection<LiteralEvaluator> allCompiled = runtime.getExpressionResolver().buildExpressions(allSources);
            for (LiteralEvaluator literalEvaluator : allCompiled) {
                LiteralExpressionHelper helper = (LiteralExpressionHelper)allExpressions.get(literalEvaluator.getSource());
                if (helper != null) {
                    perSourceLiterals.computeIfAbsent((LhsConditionsHolder)helper.holder, t -> new LinkedList()).add(new WithComplexity<LiteralEvaluator>(literalEvaluator, helper.complexity));
                    continue;
                }
                throw new IllegalStateException("Couldn't find source condition by identity");
            }
        }
        for (LhsConditionsHolder source : sources) {
            LhsConditionHandles lhsConditionHandles = map.computeIfAbsent(source, k -> new LhsConditionHandles());
            LhsConditions conditions = source.getConditions();
            for (EvaluatorHandle evaluatorHandle : conditions.directHandles) {
                lhsConditionHandles.add(evaluatorHandle);
            }
            for (WithComplexity withComplexity : conditions.evaluators) {
                EvaluatorHandle h = runtime.addEvaluator((Evaluator)withComplexity.subject, withComplexity.complexity);
                lhsConditionHandles.add(h);
            }
            Collection literals = (Collection)perSourceLiterals.get(source);
            if (literals == null) continue;
            for (WithComplexity d : literals) {
                EvaluatorHandle h = runtime.addEvaluator((Evaluator)d.subject, d.complexity);
                lhsConditionHandles.add(h);
            }
        }
        return t -> Objects.requireNonNull((LhsConditionHandles)map.get(t), "Illegal state");
    }

    static class WithComplexity<T> {
        final T subject;
        final double complexity;

        WithComplexity(T subject, double complexity) {
            this.subject = subject;
            this.complexity = complexity;
        }
    }

    static class LiteralExpressionHelper<T extends LhsConditionsHolder> {
        final T holder;
        final double complexity;

        public LiteralExpressionHelper(T holder, double complexity) {
            this.holder = holder;
            this.complexity = complexity;
        }
    }
}

