/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Function;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.FieldReference;
import org.evrete.api.LhsBuilder;
import org.evrete.api.NamedType;
import org.evrete.api.TypeField;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.LhsConditionHandles;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.evaluation.BetaEvaluator;
import org.evrete.runtime.evaluation.EvaluatorFactory;
import org.evrete.util.MapFunction;
import org.evrete.util.MapOfSet;
import org.evrete.util.NextIntSupplier;

class LhsDescriptor {
    private static final Set<EvaluatorHandle> EMPTY_ALPHA_CONDITIONS = new HashSet<EvaluatorHandle>();
    private static final Set<TypeField> EMPTY_TYPE_FIELDS = new HashSet<TypeField>();
    private final FactType[] factTypes;
    private final RhsFactGroupDescriptor[] allFactGroups;

    LhsDescriptor(AbstractRuntime<?, ?> runtime, LhsBuilder<?> builder, LhsConditionHandles lhsConditions, NextIntSupplier factIdGenerator, MapFunction<NamedType, FactType> typeMapping) {
        Collection<NamedType> declaredTypes = builder.getDeclaredFactTypes();
        MapOfSet<String, Object> alphaHandles = new MapOfSet<String, Object>();
        HashSet<EvaluatorHandle> betaHandles = new HashSet<EvaluatorHandle>();
        MapOfSet<String, Object> betaFields = new MapOfSet<String, Object>();
        for (EvaluatorHandle h : lhsConditions.getHandles()) {
            Set<NamedType> involvedTypes = h.namedTypes();
            if (involvedTypes.size() == 1) {
                alphaHandles.add(involvedTypes.iterator().next().getName(), h);
                continue;
            }
            betaHandles.add(h);
            for (FieldReference ref : h.descriptor()) {
                betaFields.add(ref.type().getName(), ref.field());
            }
        }
        HashSet<FactType> keyedFactTypes = new HashSet<FactType>();
        ArrayList<FactType> plainFactTypes = new ArrayList<FactType>();
        LinkedList<FactType> allFactTypes = new LinkedList<FactType>();
        for (NamedType namedType : declaredTypes) {
            Set<EvaluatorHandle> alphaConditions = alphaHandles.getOrDefault(namedType.getName(), EMPTY_ALPHA_CONDITIONS);
            Set<TypeField> fields = betaFields.getOrDefault(namedType.getName(), EMPTY_TYPE_FIELDS);
            FactType factType = runtime.buildFactType(namedType, fields, alphaConditions, factIdGenerator.next());
            typeMapping.putNew(namedType, factType);
            if (factType.getMemoryAddress().fields().size() == 0) {
                plainFactTypes.add(factType);
            } else {
                keyedFactTypes.add(factType);
            }
            allFactTypes.add(factType);
        }
        this.factTypes = allFactTypes.toArray(FactType.ZERO_ARRAY);
        ConditionNodeDescriptor[] finalNodes = LhsDescriptor.findBestAllocation(betaHandles, typeMapping);
        ArrayList<RhsFactGroupDescriptor> allFactGroups = new ArrayList<RhsFactGroupDescriptor>();
        for (ConditionNodeDescriptor finalNode : finalNodes) {
            RhsFactGroupDescriptor descriptor = new RhsFactGroupDescriptor(finalNode);
            allFactGroups.add(descriptor);
            Arrays.asList(descriptor.getTypes()).forEach(keyedFactTypes::remove);
        }
        assert (keyedFactTypes.isEmpty());
        if (!plainFactTypes.isEmpty()) {
            allFactGroups.add(new RhsFactGroupDescriptor(plainFactTypes));
        }
        this.allFactGroups = allFactGroups.toArray(RhsFactGroupDescriptor.ZERO_ARRAY);
    }

    private static ConditionNodeDescriptor[] findBestAllocation(Set<EvaluatorHandle> betaConditions, MapFunction<NamedType, FactType> mapping) {
        if (betaConditions.isEmpty()) {
            return ConditionNodeDescriptor.ZERO_ARRAY;
        }
        ArrayList<BetaEvaluator> evaluators = new ArrayList<BetaEvaluator>(EvaluatorFactory.flattenEvaluators(betaConditions, mapping));
        if (evaluators.isEmpty()) {
            throw new IllegalStateException();
        }
        double maxComplexity = Double.MIN_VALUE;
        double minComplexity = Double.MAX_VALUE;
        HashSet<FactType> betaTypes = new HashSet<FactType>();
        for (BetaEvaluator betaEvaluator : evaluators) {
            double complexity = betaEvaluator.getComplexity();
            if (complexity <= 0.0) {
                throw new IllegalStateException("Complexity must be a positive value");
            }
            if (complexity > maxComplexity) {
                maxComplexity = complexity;
            }
            if (complexity < minComplexity) {
                minComplexity = complexity;
            }
            betaTypes.addAll(betaEvaluator.factTypes());
        }
        HashMap<BetaEvaluator, Double> minMaxComplexities = new HashMap<BetaEvaluator, Double>();
        for (BetaEvaluator g : evaluators) {
            double newComplexity = 1.0 + (g.getComplexity() - minComplexity) / (maxComplexity - minComplexity);
            minMaxComplexities.put(g, newComplexity * (double)g.getTotalTypesInvolved());
        }
        evaluators.sort(Comparator.comparingDouble(minMaxComplexities::get).thenComparing((Function<BetaEvaluator, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/evrete/runtime/evaluation/BetaEvaluator;)Ljava/lang/String;)()));
        Collection<ConditionNodeDescriptor> collection = ConditionNodeDescriptor.allocateConditions(betaTypes, evaluators);
        return collection.toArray(ConditionNodeDescriptor.ZERO_ARRAY);
    }

    RhsFactGroupDescriptor[] getAllFactGroups() {
        return this.allFactGroups;
    }

    public FactType[] getFactTypes() {
        return this.factTypes;
    }

    public String toString() {
        return "{factGroups=" + Arrays.toString(this.allFactGroups) + '}';
    }
}

