/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import org.evrete.Configuration;
import org.evrete.api.MemoryFactory;
import org.evrete.api.Type;
import org.evrete.api.TypeResolver;
import org.evrete.api.TypeWrapper;
import org.evrete.api.ValueResolver;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.AbstractRuleSession;

abstract class MemoryComponent
implements TypeResolver {
    final MemoryFactory memoryFactory;
    final Configuration configuration;
    final ValueResolver valueResolver;
    private final AbstractRuleSession<?> runtime;
    private final ArrayOf<MemoryComponent> childComponents = new ArrayOf<MemoryComponent>(MemoryComponent.class);

    MemoryComponent(AbstractRuleSession<?> runtime, MemoryFactory memoryFactory) {
        this.memoryFactory = memoryFactory;
        this.configuration = runtime.getConfiguration();
        this.valueResolver = memoryFactory.getValueResolver();
        this.runtime = runtime;
    }

    MemoryComponent(MemoryComponent parent) {
        this.memoryFactory = parent.memoryFactory;
        this.configuration = parent.configuration;
        this.valueResolver = parent.valueResolver;
        this.runtime = parent.runtime;
        parent.addChild(this);
    }

    public AbstractRuleSession<?> getRuntime() {
        return this.runtime;
    }

    private void addChild(MemoryComponent childComponent) {
        this.childComponents.append(childComponent);
    }

    protected abstract void clearLocalData();

    public final void clear() {
        this.clearLocalData();
        for (MemoryComponent child : this.childComponents) {
            child.clear();
        }
    }

    @Override
    public TypeResolver copyOf() {
        return this.runtime.copyOf();
    }

    @Override
    public <T> Type<T> getType(String name) {
        return this.runtime.getType(name);
    }

    @Override
    public <T> Type<T> getType(int typeId) {
        return this.runtime.getType(typeId);
    }

    @Override
    public Collection<Type<?>> getKnownTypes() {
        return this.runtime.getKnownTypes();
    }

    @Override
    public void wrapType(TypeWrapper<?> typeWrapper) {
        this.runtime.wrapType((TypeWrapper)typeWrapper);
    }

    @Override
    public <T> Type<T> declare(String typeName, Class<T> javaType) {
        return this.runtime.declare(typeName, (Class)javaType);
    }

    @Override
    public <T> Type<T> declare(String typeName, String javaType) {
        return this.runtime.declare(typeName, javaType);
    }

    @Override
    public <T> Type<T> resolve(Object o) {
        return this.runtime.resolve(o);
    }
}

