/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.evrete.api.ExpressionResolver;
import org.evrete.api.FieldReference;
import org.evrete.api.JavaSourceCompiler;
import org.evrete.api.LiteralEvaluator;
import org.evrete.api.LiteralExpression;
import org.evrete.api.NamedType;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.runtime.compiler.CompilationException;
import org.evrete.spi.minimal.CompiledEvaluator;
import org.evrete.spi.minimal.ConditionStringTerm;
import org.evrete.spi.minimal.Const;
import org.evrete.spi.minimal.EvaluatorClassSource;
import org.evrete.spi.minimal.FieldReferenceImpl;
import org.evrete.spi.minimal.StringLiteralEncoder;

class DefaultExpressionResolver
implements ExpressionResolver {
    static final String SPI_LHS_STRIP_WHITESPACES = "evrete.spi.compiler.lhs-strip-whitespaces";
    private final RuntimeContext<?> context;
    private final boolean stripWhitespaces;

    DefaultExpressionResolver(RuntimeContext<?> context) {
        this.context = context;
        this.stripWhitespaces = context.getConfiguration().getAsBoolean(SPI_LHS_STRIP_WHITESPACES, true);
    }

    @Override
    public FieldReference resolve(String arg, NamedType.Resolver resolver) {
        TypeField field;
        NamedType typeRef;
        int firstDot = arg.indexOf(46);
        if (firstDot < 0) {
            typeRef = resolver.resolve(arg);
            field = typeRef.getType().getField("");
        } else {
            String lhsFactType = arg.substring(0, firstDot);
            String dottedProp = arg.substring(firstDot + 1);
            Const.assertName(dottedProp);
            Const.assertName(lhsFactType.substring(1));
            typeRef = resolver.resolve(lhsFactType);
            Type<?> type = typeRef.getType();
            field = type.getField(dottedProp);
        }
        return new FieldReferenceImpl(typeRef, field);
    }

    @Override
    public Collection<LiteralEvaluator> buildExpressions(Collection<LiteralExpression> expressions) throws CompilationException {
        Collection sources = ((Stream)expressions.stream().parallel()).map(expression -> {
            NamedType.Resolver resolver = expression.getContext();
            StringLiteralEncoder encoder = StringLiteralEncoder.of(expression.getSource(), this.stripWhitespaces);
            List<ConditionStringTerm> terms = ConditionStringTerm.resolveTerms(encoder.getEncoded(), s -> this.resolve((String)s, resolver));
            return new EvaluatorClassSource(this.context, (LiteralExpression)expression, encoder, terms);
        }).collect(Collectors.toList());
        Collection compiled = this.context.getSourceCompiler().compile(sources);
        ArrayList<LiteralEvaluator> result = new ArrayList<LiteralEvaluator>(sources.size());
        for (JavaSourceCompiler.Result r : compiled) {
            EvaluatorClassSource source = (EvaluatorClassSource)r.getSource();
            Class<?> compiledClass = r.getCompiledClass();
            try {
                MethodHandle handle = DefaultExpressionResolver.getHandle(compiledClass);
                result.add(new CompiledEvaluator(handle, source));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    static MethodHandle getHandle(Class<?> compiledClass) throws NoSuchFieldException, IllegalAccessException {
        return (MethodHandle)compiledClass.getDeclaredField("HANDLE").get(null);
    }
}

