/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.StringJoiner;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.evrete.api.FactHandle;
import org.evrete.api.FactStorage;
import org.evrete.api.ReIterator;
import org.evrete.api.Type;
import org.evrete.collections.AbstractLinearHash;
import org.evrete.spi.minimal.FactHandleImpl;

class DefaultFactStorage<T>
implements FactStorage<T> {
    private final TupleCollection<T> collection;
    private final Function<Tuple<T>, FactStorage.Entry<T>> ITERATOR_MAPPER = t -> t;

    DefaultFactStorage(Type<?> type, BiPredicate<T, T> identityFunction, int minCapacity) {
        this.collection = new TupleCollection<T>(minCapacity, type, identityFunction);
    }

    @Override
    public FactHandle insert(T fact) {
        return this.collection.insert(fact);
    }

    @Override
    public void delete(FactHandle handle) {
        this.collection.delete(handle);
    }

    @Override
    public void update(FactHandle handle, T newInstance) {
        this.collection.addSilent(new Tuple<T>((FactHandleImpl)handle, newInstance));
    }

    @Override
    public T getFact(FactHandle handle) {
        return this.collection.getFact((FactHandleImpl)handle);
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    public String toString() {
        StringJoiner sj = new StringJoiner("\n");
        this.collection.forEachDataEntry(t -> sj.add(t.toString()));
        return sj.toString();
    }

    @Override
    public ReIterator<FactStorage.Entry<T>> iterator() {
        return this.collection.iterator(this.ITERATOR_MAPPER);
    }

    static class TupleCollection<T>
    extends AbstractLinearHash<Tuple<T>> {
        private static final ToIntFunction<Object> HASH_FUNCTION = Object::hashCode;
        private final BiPredicate<T, T> identityFunction;
        private final BiPredicate<Object, Object> EQ_PREDICATE = new BiPredicate<Object, Object>(){

            @Override
            public boolean test(Object o1, Object o2) {
                Tuple t1 = (Tuple)o1;
                Tuple t2 = (Tuple)o2;
                return identityFunction.test(t1.object, t2.object);
            }
        };
        private final BiPredicate<Tuple<T>, FactHandleImpl> searchByHandle = (tuple, o) -> ((Tuple)tuple).handle.id == o.id;
        private final BiPredicate<Tuple<T>, T> searchByFact = new BiPredicate<Tuple<T>, T>(){

            @Override
            public boolean test(Tuple<T> tuple, T o) {
                return identityFunction.test(tuple.object, o);
            }
        };
        private final Type<?> type;
        private long handleId = 0L;

        TupleCollection(int minCapacity, Type<?> type, BiPredicate<T, T> identityFunction) {
            super(minCapacity);
            this.identityFunction = identityFunction;
            this.type = type;
        }

        @Override
        protected ToIntFunction<Object> getHashFunction() {
            return HASH_FUNCTION;
        }

        @Override
        protected BiPredicate<Object, Object> getEqualsPredicate() {
            return this.EQ_PREDICATE;
        }

        FactHandleImpl insert(T fact) {
            this.resize();
            int hash = HASH_FUNCTION.applyAsInt(fact);
            int pos = this.findBinIndex(fact, hash, this.searchByFact);
            Tuple<T> tuple = (Tuple<T>)this.get(pos);
            if (tuple == null) {
                FactHandleImpl handle = new FactHandleImpl(this.handleId++, hash, this.type.getId());
                tuple = new Tuple<T>(handle, fact);
                this.saveDirect(tuple, pos);
                return handle;
            }
            return null;
        }

        void delete(FactHandle handle) {
            FactHandleImpl impl = (FactHandleImpl)handle;
            int pos = this.findBinIndex(impl, impl.hash, this.searchByHandle);
            if (this.get(pos) != null) {
                this.markDeleted(pos);
            }
        }

        T getFact(FactHandleImpl impl) {
            Tuple t = (Tuple)this.get(this.findBinIndex(impl, impl.hash, this.searchByHandle));
            return (T)(t == null ? null : t.object);
        }
    }

    static class Tuple<Z>
    implements FactStorage.Entry<Z> {
        private final FactHandleImpl handle;
        private final Z object;

        Tuple(FactHandleImpl handle, Z object) {
            this.handle = handle;
            this.object = object;
        }

        @Override
        public FactHandle getHandle() {
            return this.handle;
        }

        @Override
        public Z getInstance() {
            return this.object;
        }

        public int hashCode() {
            return this.handle.hash;
        }

        public String toString() {
            return this.handle + " -> " + this.object;
        }
    }
}

