/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.evrete.runtime.compiler.CompilationException;

public interface JavaSourceCompiler {
    public <S extends ClassSource> Collection<Result<S>> compile(Collection<S> var1) throws CompilationException;

    public ClassSource resolve(String var1);

    default public Map<String, Class<?>> compile(Set<String> sources) throws CompilationException {
        HashMap<String, ClassSource> sourceMap = new HashMap<String, ClassSource>(sources.size());
        for (String source : sources) {
            sourceMap.put(source, this.resolve(source));
        }
        HashMap resultMap = new HashMap(sources.size());
        Collection results = this.compile(sourceMap.values());
        for (Result r : results) {
            resultMap.put(r.getSource().getSource(), r.getCompiledClass());
        }
        return resultMap;
    }

    default public Class<?> compile(String source) throws CompilationException {
        Map<String, Class<?>> m = this.compile(Collections.singleton(source));
        Class<?> cl = m.get(source);
        if (cl == null) {
            throw new IllegalStateException();
        }
        return cl;
    }

    public void defineClass(String var1, byte[] var2);

    public static interface Result<S extends ClassSource> {
        public S getSource();

        public Class<?> getCompiledClass();
    }

    public static interface ClassSource {
        public String binaryName();

        public String getSource();
    }
}

